/************************************************************************************************/
/* Stata User File for H163 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H163.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H163.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H163.DO                                               */
/* The program below will output the Stata dataset H163.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID13 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR13 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE13 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS13 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE13 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION13 79-80
  int    REFPRS31 81-83
  int    REFPRS42 84-86
  int    REFPRS53 87-89
  int    REFPRS13 90-92
  byte   RESP31 93-93
  byte   RESP42 94-94
  byte   RESP53 95-95
  byte   RESP13 96-96
  byte   PROXY31 97-98
  byte   PROXY42 99-100
  byte   PROXY53 101-102
  byte   PROXY13 103-103
  byte   INTVLANG 104-105
  byte   BEGRFM31 106-107
  int    BEGRFY31 108-111
  byte   ENDRFM31 112-113
  int    ENDRFY31 114-117
  byte   BEGRFM42 118-119
  int    BEGRFY42 120-123
  byte   ENDRFM42 124-125
  int    ENDRFY42 126-129
  byte   BEGRFM53 130-131
  int    BEGRFY53 132-135
  byte   ENDRFM53 136-137
  int    ENDRFY53 138-141
  byte   ENDRFM13 142-143
  int    ENDRFY13 144-147
  byte   KEYNESS 148-148
  byte   INSCOP31 149-149
  byte   INSCOP42 150-150
  byte   INSCOP53 151-151
  byte   INSCOP13 152-152
  byte   INSC1231 153-153
  byte   INSCOPE 154-154
  byte   ELGRND31 155-155
  byte   ELGRND42 156-156
  byte   ELGRND53 157-157
  byte   ELGRND13 158-158
  byte   PSTATS31 159-160
  byte   PSTATS42 161-162
  byte   PSTATS53 163-164
  str    RURSLT31 165-166
  str    RURSLT42 167-168
  str    RURSLT53 169-170
  byte   AGE31X 171-172
  byte   AGE42X 173-174
  byte   AGE53X 175-176
  byte   AGE13X 177-178
  byte   AGELAST 179-180
  byte   DOBMM 181-182
  int    DOBYY 183-186
  byte   SEX 187-187
  byte   RACEVER 188-188
  byte   RACEV1X 189-189
  byte   RACEV2X 190-191
  byte   RACEAX 192-192
  byte   RACEBX 193-193
  byte   RACEWX 194-194
  byte   RACETHX 195-195
  byte   HISPANX 196-196
  byte   HISPCAT 197-198
  byte   HISPNCAT 199-200
  byte   MARRY31X 201-202
  byte   MARRY42X 203-204
  byte   MARRY53X 205-206
  byte   MARRY13X 207-208
  int    SPOUID31 209-211
  int    SPOUID42 212-214
  int    SPOUID53 215-217
  int    SPOUID13 218-220
  byte   SPOUIN31 221-222
  byte   SPOUIN42 223-224
  byte   SPOUIN53 225-226
  byte   SPOUIN13 227-228
  byte   EDUYRDG 229-230
  byte   EDRECODE 231-232
  byte   FTSTU31X 233-234
  byte   FTSTU42X 235-236
  byte   FTSTU53X 237-238
  byte   FTSTU13X 239-240
  byte   ACTDTY31 241-242
  byte   ACTDTY42 243-244
  byte   ACTDTY53 245-246
  byte   HONRDC31 247-248
  byte   HONRDC42 249-250
  byte   HONRDC53 251-252
  byte   REFRL31X 253-254
  byte   REFRL42X 255-256
  byte   REFRL53X 257-258
  byte   REFRL13X 259-260
  byte   OTHLANG 261-262
  byte   LANGSPK 263-264
  byte   HWELLSPE 265-266
  byte   BORNUSA 267-268
  byte   YRSINUS 269-270
  int    MOPID31X 271-273
  int    MOPID42X 274-276
  int    MOPID53X 277-279
  int    DAPID31X 280-282
  int    DAPID42X 283-285
  int    DAPID53X 286-288
  byte   RTHLTH31 289-290
  byte   RTHLTH42 291-292
  byte   RTHLTH53 293-294
  byte   MNHLTH31 295-296
  byte   MNHLTH42 297-298
  byte   MNHLTH53 299-300
  byte   HIBPDX 301-302
  byte   HIBPAGED 303-304
  byte   BPMLDX 305-306
  byte   CHDDX 307-308
  byte   CHDAGED 309-310
  byte   ANGIDX 311-312
  byte   ANGIAGED 313-314
  byte   MIDX 315-316
  byte   MIAGED 317-318
  byte   OHRTDX 319-320
  byte   OHRTAGED 321-322
  byte   STRKDX 323-324
  byte   STRKAGED 325-326
  byte   EMPHDX 327-328
  byte   EMPHAGED 329-330
  byte   CHBRON31 331-332
  byte   CHBRON53 333-334
  byte   CHOLDX 335-336
  byte   CHOLAGED 337-338
  byte   CANCERDX 339-340
  byte   CABLADDR 341-342
  byte   CABREAST 343-344
  byte   CACERVIX 345-346
  byte   CACOLON 347-348
  byte   CALUNG 349-350
  byte   CALYMPH 351-352
  byte   CAMELANO 353-354
  byte   CAOTHER 355-356
  byte   CAPROSTA 357-358
  byte   CASKINNM 359-360
  byte   CASKINDK 361-362
  byte   CAUTERUS 363-364
  byte   DIABDX 365-366
  byte   DIABAGED 367-368
  byte   JTPAIN31 369-370
  byte   JTPAIN53 371-372
  byte   ARTHDX 373-374
  byte   ARTHTYPE 375-376
  byte   ARTHAGED 377-378
  byte   ASTHDX 379-380
  byte   ASTHAGED 381-382
  byte   ASSTIL31 383-384
  byte   ASSTIL53 385-386
  byte   ASATAK31 387-388
  byte   ASATAK53 389-390
  byte   ASTHEP31 391-392
  byte   ASTHEP53 393-394
  byte   ASACUT53 395-396
  byte   ASMRCN53 397-398
  byte   ASPREV53 399-400
  byte   ASDALY53 401-402
  byte   ASPKFL53 403-404
  byte   ASEVFL53 405-406
  byte   ASWNFL53 407-408
  byte   ADHDADDX 409-410
  byte   ADHDAGED 411-412
  byte   PREGNT31 413-414
  byte   PREGNT42 415-416
  byte   PREGNT53 417-418
  byte   IADLHP31 419-420
  byte   IADLHP53 421-422
  byte   IADL3M31 423-424
  byte   ADLHLP31 425-426
  byte   ADLHLP53 427-428
  byte   ADL3MO31 429-430
  byte   AIDHLP31 431-432
  byte   AIDHLP53 433-434
  byte   WLKLIM31 435-436
  byte   WLKLIM53 437-438
  byte   LFTDIF31 439-440
  byte   LFTDIF53 441-442
  byte   STPDIF31 443-444
  byte   STPDIF53 445-446
  byte   WLKDIF31 447-448
  byte   WLKDIF53 449-450
  byte   MILDIF31 451-452
  byte   MILDIF53 453-454
  byte   STNDIF31 455-456
  byte   STNDIF53 457-458
  byte   BENDIF31 459-460
  byte   BENDIF53 461-462
  byte   RCHDIF31 463-464
  byte   RCHDIF53 465-466
  byte   FNGRDF31 467-468
  byte   FNGRDF53 469-470
  byte   WLK3MO31 471-472
  byte   ACTLIM31 473-474
  byte   ACTLIM53 475-476
  byte   WRKLIM31 477-478
  byte   WRKLIM53 479-480
  byte   HSELIM31 481-482
  byte   HSELIM53 483-484
  byte   SCHLIM31 485-486
  byte   SCHLIM53 487-488
  byte   UNABLE31 489-490
  byte   UNABLE53 491-492
  byte   SOCLIM31 493-494
  byte   SOCLIM53 495-496
  byte   COGLIM31 497-498
  byte   COGLIM53 499-500
  byte   DFHEAR42 501-502
  byte   DEAF42 503-504
  byte   DFSEE42 505-506
  byte   BLIND42 507-508
  byte   DFCOG42 509-510
  byte   DFWLKC42 511-512
  byte   DFDRSB42 513-514
  byte   DFERND42 515-516
  byte   HEARAD42 517-518
  byte   WRGLAS42 519-520
  byte   ANYLMT13 521-522
  byte   LSHLTH42 523-524
  byte   NEVILL42 525-526
  byte   SICEAS42 527-528
  byte   HLTHLF42 529-530
  byte   WRHLTH42 531-532
  byte   CHPMED42 533-534
  byte   CHPMHB42 535-536
  byte   CHPMCN42 537-538
  byte   CHSERV42 539-540
  byte   CHSRHB42 541-542
  byte   CHSRCN42 543-544
  byte   CHLIMI42 545-546
  byte   CHLIHB42 547-548
  byte   CHLICO42 549-550
  byte   CHTHER42 551-552
  byte   CHTHHB42 553-554
  byte   CHTHCO42 555-556
  byte   CHCOUN42 557-558
  byte   CHEMPB42 559-560
  byte   CSHCN42 561-562
  byte   MOMPRO42 563-564
  byte   DADPRO42 565-566
  byte   UNHAP42 567-568
  byte   SCHLBH42 569-570
  byte   HAVFUN42 571-572
  byte   ADUPRO42 573-574
  byte   NERVAF42 575-576
  byte   SIBPRO42 577-578
  byte   KIDPRO42 579-580
  byte   SPRPRO42 581-582
  byte   SCHPRO42 583-584
  byte   HOMEBH42 585-586
  byte   TRBLE42 587-588
  byte   CHILCR42 589-590
  byte   CHILWW42 591-592
  byte   CHRTCR42 593-594
  byte   CHRTWW42 595-596
  byte   CHAPPT42 597-598
  byte   CHNDCR42 599-600
  byte   CHENEC42 601-602
  byte   CHLIST42 603-604
  byte   CHEXPL42 605-606
  byte   CHRESP42 607-608
  byte   CHPRTM42 609-610
  byte   CHHECR42 611-612
  byte   CHSPEC42 613-614
  byte   CHEYRE42 615-616
  byte   MESHGT42 617-618
  byte   WHNHGT42 619-620
  byte   MESWGT42 621-622
  byte   WHNWGT42 623-624
  double CHBMIX42 625-629
  byte   MESVIS42 630-631
  byte   MESBPR42 632-633
  byte   WHNBPR42 634-635
  byte   DENTAL42 636-637
  byte   WHNDEN42 638-639
  byte   EATHLT42 640-641
  byte   WHNEAT42 642-643
  byte   PHYSCL42 644-645
  byte   WHNPHY42 646-647
  byte   SAFEST42 648-649
  byte   WHNSAF42 650-651
  byte   BOOST42 652-653
  byte   WHNBST42 654-655
  byte   LAPBLT42 656-657
  byte   WHNLAP42 658-659
  byte   HELMET42 660-661
  byte   WHNHEL42 662-663
  byte   NOSMOK42 664-665
  byte   WHNSMK42 666-667
  byte   TIMALN42 668-669
  byte   DENTCK53 670-671
  byte   BPCHEK53 672-673
  byte   CHOLCK53 674-675
  byte   CHECK53 676-677
  byte   NOFAT53 678-679
  byte   EXRCIS53 680-681
  byte   FLUSHT53 682-683
  byte   ASPRIN53 684-685
  byte   NOASPR53 686-687
  byte   STOMCH53 688-689
  byte   LSTETH53 690-691
  byte   PSA53 692-693
  byte   HYSTER53 694-695
  byte   PAPSMR53 696-697
  byte   BRSTEX53 698-699
  byte   MAMOGR53 700-701
  byte   BSTST53 702-703
  byte   BSTSRE53 704-705
  byte   CLNTST53 706-707
  byte   CLNTRE53 708-709
  byte   SGMTST53 710-711
  byte   SGMTRE53 712-713
  byte   PHYEXE53 714-715
  double BMINDX53 716-719
  byte   SEATBE53 720-721
  byte   SAQELIG 722-722
  int    ADPRX42 723-725
  byte   ADILCR42 726-727
  byte   ADILWW42 728-729
  byte   ADRTCR42 730-731
  byte   ADRTWW42 732-733
  byte   ADAPPT42 734-735
  byte   ADNDCR42 736-737
  byte   ADEGMC42 738-739
  byte   ADLIST42 740-741
  byte   ADEXPL42 742-743
  byte   ADRESP42 744-745
  byte   ADPRTM42 746-747
  byte   ADINST42 748-749
  byte   ADEZUN42 750-751
  byte   ADTLHW42 752-753
  byte   ADFFRM42 754-755
  byte   ADFHLP42 756-757
  byte   ADHECR42 758-759
  byte   ADSMOK42 760-761
  byte   ADNSMK42 762-763
  byte   ADDRBP42 764-765
  byte   ADSPEC42 766-767
  byte   ADESSP42 768-769
  byte   ADGENH42 770-771
  byte   ADDAYA42 772-773
  byte   ADCLIM42 774-775
  byte   ADPALS42 776-777
  byte   ADPWLM42 778-779
  byte   ADMALS42 780-781
  byte   ADMWLM42 782-783
  byte   ADPAIN42 784-785
  byte   ADCAPE42 786-787
  byte   ADNRGY42 788-789
  byte   ADDOWN42 790-791
  byte   ADSOCA42 792-793
  double PCS42 794-798
  double MCS42 799-803
  byte   SFFLAG42 804-805
  byte   ADNERV42 806-807
  byte   ADHOPE42 808-809
  byte   ADREST42 810-811
  byte   ADSAD42 812-813
  byte   ADEFRT42 814-815
  byte   ADWRTH42 816-817
  byte   K6SUM42 818-819
  byte   ADINTR42 820-821
  byte   ADDPRS42 822-823
  byte   PHQ242 824-825
  byte   ADINSA42 826-827
  byte   ADINSB42 828-829
  byte   ADRISK42 830-831
  byte   ADOVER42 832-833
  byte   ADCMPM42 834-835
  int    ADCMPY42 836-839
  byte   ADLANG42 840-841
  byte   DSDIA53 842-843
  byte   DSA1C53 844-845
  byte   DSFT1453 846-847
  byte   DSFT1353 848-849
  byte   DSFT1253 850-851
  byte   DSFB1253 852-853
  byte   DSFTNV53 854-855
  byte   DSEY1453 856-857
  byte   DSEY1353 858-859
  byte   DSEY1253 860-861
  byte   DSEB1253 862-863
  byte   DSEYNV53 864-865
  byte   DSCH1453 866-867
  byte   DSCH1353 868-869
  byte   DSCH1253 870-871
  byte   DSCB1253 872-873
  byte   DSCHNV53 874-875
  byte   DSFL1453 876-877
  byte   DSFL1353 878-879
  byte   DSFL1253 880-881
  byte   DSVB1253 882-883
  byte   DSFLNV53 884-885
  byte   DSKIDN53 886-887
  byte   DSEYPR53 888-889
  byte   DSDIET53 890-891
  byte   DSMED53 892-893
  byte   DSINSU53 894-895
  byte   DSCPCP53 896-897
  byte   DSCNPC53 898-899
  byte   DSCPHN53 900-901
  byte   DSCINT53 902-903
  byte   DSCGRP53 904-905
  byte   DSCONF53 906-907
  byte   DSPRX53 908-909
  int    DDNWRK31 910-912
  int    DDNWRK42 913-915
  int    DDNWRK53 916-918
  byte   DDNSCL31 919-920
  int    DDNSCL42 921-923
  byte   DDNSCL53 924-925
  byte   OTHDYS31 926-927
  byte   OTHDYS42 928-929
  byte   OTHDYS53 930-931
  byte   OTHNDD31 932-933
  int    OTHNDD42 934-936
  int    OTHNDD53 937-939
  byte   ACCELI42 940-941
  byte   LANGHM42 942-943
  byte   ENGCMF42 944-945
  byte   ENGSPK42 946-947
  byte   USBORN42 948-949
  byte   LIVEUS42 950-951
  byte   HAVEUS42 952-953
  byte   YNOUSC42 954-955
  byte   NOREAS42 956-957
  byte   SELDSI42 958-959
  byte   NEWARE42 960-961
  byte   DKWHRU42 962-963
  byte   USCNOT42 964-965
  byte   PERSLA42 966-967
  byte   DIFFPL42 968-969
  byte   INSRPL42 970-971
  byte   MYSELF42 972-973
  byte   CARECO42 974-975
  byte   NOHINS42 976-977
  byte   OTHINS42 978-979
  byte   JOBRSN42 980-981
  byte   NEWDOC42 982-983
  byte   DOCELS42 984-985
  byte   NOLIKE42 986-987
  byte   HEALTH42 988-989
  byte   KNOWDR42 990-991
  byte   ONJOB42 992-993
  byte   NOGODR42 994-995
  byte   TRANS42 996-997
  byte   CLINIC42 998-999
  byte   OTHREA42 1000-1001
  byte   PROVTY42 1002-1003
  byte   PLCTYP42 1004-1005
  byte   GOTOUS42 1006-1007
  byte   TMTKUS42 1008-1009
  byte   DFTOUS42 1010-1011
  byte   TYPEPE42 1012-1013
  byte   LOCATN42 1014-1015
  byte   HSPLAP42 1016-1017
  byte   WHITPR42 1018-1019
  byte   BLCKPR42 1020-1021
  byte   ASIANP42 1022-1023
  byte   NATAMP42 1024-1025
  byte   PACISP42 1026-1027
  byte   OTHRCP42 1028-1029
  byte   GENDRP42 1030-1031
  byte   MINORP42 1032-1033
  byte   PREVEN42 1034-1035
  byte   REFFRL42 1036-1037
  byte   ONGONG42 1038-1039
  byte   PHNREG42 1040-1041
  byte   OFFHOU42 1042-1043
  byte   AFTHOU42 1044-1045
  byte   TREATM42 1046-1047
  byte   RESPCT42 1048-1049
  byte   DECIDE42 1050-1051
  byte   EXPLOP42 1052-1053
  byte   LANGPR42 1054-1055
  byte   PRVSPK42 1056-1057
  byte   MDUNAB42 1058-1059
  byte   MDUNRS42 1060-1061
  byte   MDUNPR42 1062-1063
  byte   MDDLAY42 1064-1065
  byte   MDDLRS42 1066-1067
  byte   MDDLPR42 1068-1069
  byte   DNUNAB42 1070-1071
  byte   DNUNRS42 1072-1073
  byte   DNUNPR42 1074-1075
  byte   DNDLAY42 1076-1077
  byte   DNDLRS42 1078-1079
  byte   DNDLPR42 1080-1081
  byte   PMUNAB42 1082-1083
  byte   PMUNRS42 1084-1085
  byte   PMUNPR42 1086-1087
  byte   PMDLAY42 1088-1089
  byte   PMDLRS42 1090-1091
  byte   PMDLPR42 1092-1093
  byte   EMPST31 1094-1095
  byte   EMPST42 1096-1097
  byte   EMPST53 1098-1099
  byte   RNDFLG31 1100-1101
  byte   MORJOB31 1102-1103
  byte   MORJOB42 1104-1105
  byte   MORJOB53 1106-1107
  byte   EVRWRK 1108-1109
  double HRWG31X 1110-1115
  double HRWG42X 1116-1121
  double HRWG53X 1122-1127
  byte   HRWGIM31 1128-1128
  byte   HRWGIM42 1129-1129
  byte   HRWGIM53 1130-1130
  byte   HRHOW31 1131-1132
  byte   HRHOW42 1133-1134
  byte   HRHOW53 1135-1136
  byte   DIFFWG31 1137-1138
  byte   DIFFWG42 1139-1140
  byte   DIFFWG53 1141-1142
  double NHRWG31 1143-1148
  double NHRWG42 1149-1154
  double NHRWG53 1155-1160
  int    HOUR31 1161-1163
  int    HOUR42 1164-1166
  int    HOUR53 1167-1169
  byte   TEMPJB31 1170-1171
  byte   TEMPJB42 1172-1173
  byte   TEMPJB53 1174-1175
  byte   SSNLJB31 1176-1177
  byte   SSNLJB42 1178-1179
  byte   SSNLJB53 1180-1181
  byte   SELFCM31 1182-1183
  byte   SELFCM42 1184-1185
  byte   SELFCM53 1186-1187
  byte   DISVW31X 1188-1189
  byte   DISVW42X 1190-1191
  byte   DISVW53X 1192-1193
  byte   CHOIC31 1194-1195
  byte   CHOIC42 1196-1197
  byte   CHOIC53 1198-1199
  byte   INDCAT31 1200-1201
  byte   INDCAT42 1202-1203
  byte   INDCAT53 1204-1205
  int    NUMEMP31 1206-1208
  int    NUMEMP42 1209-1211
  int    NUMEMP53 1212-1214
  byte   MORE31 1215-1216
  byte   MORE42 1217-1218
  byte   MORE53 1219-1220
  byte   UNION31 1221-1222
  byte   UNION42 1223-1224
  byte   UNION53 1225-1226
  byte   NWK31 1227-1228
  byte   NWK42 1229-1230
  byte   NWK53 1231-1232
  byte   CHGJ3142 1233-1234
  byte   CHGJ4253 1235-1236
  byte   YCHJ3142 1237-1238
  byte   YCHJ4253 1239-1240
  byte   STJBMM31 1241-1242
  int    STJBYY31 1243-1246
  byte   STJBMM42 1247-1248
  int    STJBYY42 1249-1252
  byte   STJBMM53 1253-1254
  int    STJBYY53 1255-1258
  byte   EVRETIRE 1259-1260
  byte   OCCCAT31 1261-1262
  byte   OCCCAT42 1263-1264
  byte   OCCCAT53 1265-1266
  byte   PAYVAC31 1267-1268
  byte   PAYVAC42 1269-1270
  byte   PAYVAC53 1271-1272
  byte   SICPAY31 1273-1274
  byte   SICPAY42 1275-1276
  byte   SICPAY53 1277-1278
  byte   PAYDR31 1279-1280
  byte   PAYDR42 1281-1282
  byte   PAYDR53 1283-1284
  byte   RETPLN31 1285-1286
  byte   RETPLN42 1287-1288
  byte   RETPLN53 1289-1290
  byte   BSNTY31 1291-1292
  byte   BSNTY42 1293-1294
  byte   BSNTY53 1295-1296
  byte   JOBORG31 1297-1298
  byte   JOBORG42 1299-1300
  byte   JOBORG53 1301-1302
  byte   HELD31X 1303-1304
  byte   HELD42X 1305-1306
  byte   HELD53X 1307-1308
  byte   OFFER31X 1309-1310
  byte   OFFER42X 1311-1312
  byte   OFFER53X 1313-1314
  byte   OFREMP31 1315-1316
  byte   OFREMP42 1317-1318
  byte   OFREMP53 1319-1320
  byte   AFDC13 1321-1322
  byte   FILEDR13 1323-1324
  byte   WILFIL13 1325-1326
  byte   FLSTAT13 1327-1328
  byte   FILER13 1329-1330
  byte   JTINRU13 1331-1332
  int    JNTPID13 1333-1335
  byte   CLMDEP13 1336-1337
  byte   DEPDNT13 1338-1339
  byte   DPINRU13 1340-1341
  byte   DPOTSD13 1342-1343
  byte   TAXFRM13 1344-1345
  byte   DEDUCT13 1346-1347
  byte   TOTDED13 1348-1349
  byte   CLMHIP13 1350-1351
  byte   EICRDT13 1352-1353
  byte   FOODST13 1354-1355
  byte   FOODMN13 1356-1357
  int    FOODVL13 1358-1361
  long   TTLP13X 1362-1368
  long   FAMINC13 1369-1375
  byte   POVCAT13 1376-1376
  double POVLEV13 1377-1388
  long   WAGEP13X 1389-1394
  byte   WAGIMP13 1395-1395
  long   BUSNP13X 1396-1401
  byte   BUSIMP13 1402-1402
  long   UNEMP13X 1403-1407
  byte   UNEIMP13 1408-1408
  long   WCMPP13X 1409-1413
  byte   WCPIMP13 1414-1414
  long   INTRP13X 1415-1419
  byte   INTIMP13 1420-1420
  long   DIVDP13X 1421-1426
  byte   DIVIMP13 1427-1427
  long   SALEP13X 1428-1434
  byte   SALIMP13 1435-1435
  long   PENSP13X 1436-1440
  byte   PENIMP13 1441-1441
  long   SSECP13X 1442-1446
  byte   SSCIMP13 1447-1447
  long   TRSTP13X 1448-1454
  byte   TRTIMP13 1455-1455
  long   VETSP13X 1456-1460
  byte   VETIMP13 1461-1461
  long   IRASP13X 1462-1467
  byte   IRAIMP13 1468-1468
  long   ALIMP13X 1469-1473
  byte   ALIIMP13 1474-1474
  long   CHLDP13X 1475-1479
  byte   CHLIMP13 1480-1480
  long   CASHP13X 1481-1486
  byte   CSHIMP13 1487-1487
  long   SSIP13X 1488-1492
  byte   SSIIMP13 1493-1493
  int    PUBP13X 1494-1497
  byte   PUBIMP13 1498-1498
  long   OTHRP13X 1499-1503
  byte   OTHIMP13 1504-1504
  str    HIEUIDX 1505-1511
  byte   TRIJA13X 1512-1513
  byte   TRIFE13X 1514-1515
  byte   TRIMA13X 1516-1517
  byte   TRIAP13X 1518-1519
  byte   TRIMY13X 1520-1521
  byte   TRIJU13X 1522-1523
  byte   TRIJL13X 1524-1525
  byte   TRIAU13X 1526-1527
  byte   TRISE13X 1528-1529
  byte   TRIOC13X 1530-1531
  byte   TRINO13X 1532-1533
  byte   TRIDE13X 1534-1535
  byte   MCRJA13 1536-1537
  byte   MCRFE13 1538-1539
  byte   MCRMA13 1540-1541
  byte   MCRAP13 1542-1543
  byte   MCRMY13 1544-1545
  byte   MCRJU13 1546-1547
  byte   MCRJL13 1548-1549
  byte   MCRAU13 1550-1551
  byte   MCRSE13 1552-1553
  byte   MCROC13 1554-1555
  byte   MCRNO13 1556-1557
  byte   MCRDE13 1558-1559
  byte   MCRJA13X 1560-1561
  byte   MCRFE13X 1562-1563
  byte   MCRMA13X 1564-1565
  byte   MCRAP13X 1566-1567
  byte   MCRMY13X 1568-1569
  byte   MCRJU13X 1570-1571
  byte   MCRJL13X 1572-1573
  byte   MCRAU13X 1574-1575
  byte   MCRSE13X 1576-1577
  byte   MCROC13X 1578-1579
  byte   MCRNO13X 1580-1581
  byte   MCRDE13X 1582-1583
  byte   MCDJA13 1584-1585
  byte   MCDFE13 1586-1587
  byte   MCDMA13 1588-1589
  byte   MCDAP13 1590-1591
  byte   MCDMY13 1592-1593
  byte   MCDJU13 1594-1595
  byte   MCDJL13 1596-1597
  byte   MCDAU13 1598-1599
  byte   MCDSE13 1600-1601
  byte   MCDOC13 1602-1603
  byte   MCDNO13 1604-1605
  byte   MCDDE13 1606-1607
  byte   MCDJA13X 1608-1609
  byte   MCDFE13X 1610-1611
  byte   MCDMA13X 1612-1613
  byte   MCDAP13X 1614-1615
  byte   MCDMY13X 1616-1617
  byte   MCDJU13X 1618-1619
  byte   MCDJL13X 1620-1621
  byte   MCDAU13X 1622-1623
  byte   MCDSE13X 1624-1625
  byte   MCDOC13X 1626-1627
  byte   MCDNO13X 1628-1629
  byte   MCDDE13X 1630-1631
  byte   OPAJA13 1632-1633
  byte   OPAFE13 1634-1635
  byte   OPAMA13 1636-1637
  byte   OPAAP13 1638-1639
  byte   OPAMY13 1640-1641
  byte   OPAJU13 1642-1643
  byte   OPAJL13 1644-1645
  byte   OPAAU13 1646-1647
  byte   OPASE13 1648-1649
  byte   OPAOC13 1650-1651
  byte   OPANO13 1652-1653
  byte   OPADE13 1654-1655
  byte   OPBJA13 1656-1657
  byte   OPBFE13 1658-1659
  byte   OPBMA13 1660-1661
  byte   OPBAP13 1662-1663
  byte   OPBMY13 1664-1665
  byte   OPBJU13 1666-1667
  byte   OPBJL13 1668-1669
  byte   OPBAU13 1670-1671
  byte   OPBSE13 1672-1673
  byte   OPBOC13 1674-1675
  byte   OPBNO13 1676-1677
  byte   OPBDE13 1678-1679
  byte   STAJA13 1680-1681
  byte   STAFE13 1682-1683
  byte   STAMA13 1684-1685
  byte   STAAP13 1686-1687
  byte   STAMY13 1688-1689
  byte   STAJU13 1690-1691
  byte   STAJL13 1692-1693
  byte   STAAU13 1694-1695
  byte   STASE13 1696-1697
  byte   STAOC13 1698-1699
  byte   STANO13 1700-1701
  byte   STADE13 1702-1703
  byte   PUBJA13X 1704-1705
  byte   PUBFE13X 1706-1707
  byte   PUBMA13X 1708-1709
  byte   PUBAP13X 1710-1711
  byte   PUBMY13X 1712-1713
  byte   PUBJU13X 1714-1715
  byte   PUBJL13X 1716-1717
  byte   PUBAU13X 1718-1719
  byte   PUBSE13X 1720-1721
  byte   PUBOC13X 1722-1723
  byte   PUBNO13X 1724-1725
  byte   PUBDE13X 1726-1727
  byte   PEGJA13 1728-1729
  byte   PEGFE13 1730-1731
  byte   PEGMA13 1732-1733
  byte   PEGAP13 1734-1735
  byte   PEGMY13 1736-1737
  byte   PEGJU13 1738-1739
  byte   PEGJL13 1740-1741
  byte   PEGAU13 1742-1743
  byte   PEGSE13 1744-1745
  byte   PEGOC13 1746-1747
  byte   PEGNO13 1748-1749
  byte   PEGDE13 1750-1751
  byte   PDKJA13 1752-1753
  byte   PDKFE13 1754-1755
  byte   PDKMA13 1756-1757
  byte   PDKAP13 1758-1759
  byte   PDKMY13 1760-1761
  byte   PDKJU13 1762-1763
  byte   PDKJL13 1764-1765
  byte   PDKAU13 1766-1767
  byte   PDKSE13 1768-1769
  byte   PDKOC13 1770-1771
  byte   PDKNO13 1772-1773
  byte   PDKDE13 1774-1775
  byte   PNGJA13 1776-1777
  byte   PNGFE13 1778-1779
  byte   PNGMA13 1780-1781
  byte   PNGAP13 1782-1783
  byte   PNGMY13 1784-1785
  byte   PNGJU13 1786-1787
  byte   PNGJL13 1788-1789
  byte   PNGAU13 1790-1791
  byte   PNGSE13 1792-1793
  byte   PNGOC13 1794-1795
  byte   PNGNO13 1796-1797
  byte   PNGDE13 1798-1799
  byte   POGJA13 1800-1801
  byte   POGFE13 1802-1803
  byte   POGMA13 1804-1805
  byte   POGAP13 1806-1807
  byte   POGMY13 1808-1809
  byte   POGJU13 1810-1811
  byte   POGJL13 1812-1813
  byte   POGAU13 1814-1815
  byte   POGSE13 1816-1817
  byte   POGOC13 1818-1819
  byte   POGNO13 1820-1821
  byte   POGDE13 1822-1823
  byte   PRSJA13 1824-1825
  byte   PRSFE13 1826-1827
  byte   PRSMA13 1828-1829
  byte   PRSAP13 1830-1831
  byte   PRSMY13 1832-1833
  byte   PRSJU13 1834-1835
  byte   PRSJL13 1836-1837
  byte   PRSAU13 1838-1839
  byte   PRSSE13 1840-1841
  byte   PRSOC13 1842-1843
  byte   PRSNO13 1844-1845
  byte   PRSDE13 1846-1847
  byte   POUJA13 1848-1849
  byte   POUFE13 1850-1851
  byte   POUMA13 1852-1853
  byte   POUAP13 1854-1855
  byte   POUMY13 1856-1857
  byte   POUJU13 1858-1859
  byte   POUJL13 1860-1861
  byte   POUAU13 1862-1863
  byte   POUSE13 1864-1865
  byte   POUOC13 1866-1867
  byte   POUNO13 1868-1869
  byte   POUDE13 1870-1871
  byte   PRIJA13 1872-1873
  byte   PRIFE13 1874-1875
  byte   PRIMA13 1876-1877
  byte   PRIAP13 1878-1879
  byte   PRIMY13 1880-1881
  byte   PRIJU13 1882-1883
  byte   PRIJL13 1884-1885
  byte   PRIAU13 1886-1887
  byte   PRISE13 1888-1889
  byte   PRIOC13 1890-1891
  byte   PRINO13 1892-1893
  byte   PRIDE13 1894-1895
  byte   HPEJA13 1896-1897
  byte   HPEFE13 1898-1899
  byte   HPEMA13 1900-1901
  byte   HPEAP13 1902-1903
  byte   HPEMY13 1904-1905
  byte   HPEJU13 1906-1907
  byte   HPEJL13 1908-1909
  byte   HPEAU13 1910-1911
  byte   HPESE13 1912-1913
  byte   HPEOC13 1914-1915
  byte   HPENO13 1916-1917
  byte   HPEDE13 1918-1919
  byte   HPDJA13 1920-1921
  byte   HPDFE13 1922-1923
  byte   HPDMA13 1924-1925
  byte   HPDAP13 1926-1927
  byte   HPDMY13 1928-1929
  byte   HPDJU13 1930-1931
  byte   HPDJL13 1932-1933
  byte   HPDAU13 1934-1935
  byte   HPDSE13 1936-1937
  byte   HPDOC13 1938-1939
  byte   HPDNO13 1940-1941
  byte   HPDDE13 1942-1943
  byte   HPNJA13 1944-1945
  byte   HPNFE13 1946-1947
  byte   HPNMA13 1948-1949
  byte   HPNAP13 1950-1951
  byte   HPNMY13 1952-1953
  byte   HPNJU13 1954-1955
  byte   HPNJL13 1956-1957
  byte   HPNAU13 1958-1959
  byte   HPNSE13 1960-1961
  byte   HPNOC13 1962-1963
  byte   HPNNO13 1964-1965
  byte   HPNDE13 1966-1967
  byte   HPOJA13 1968-1969
  byte   HPOFE13 1970-1971
  byte   HPOMA13 1972-1973
  byte   HPOAP13 1974-1975
  byte   HPOMY13 1976-1977
  byte   HPOJU13 1978-1979
  byte   HPOJL13 1980-1981
  byte   HPOAU13 1982-1983
  byte   HPOSE13 1984-1985
  byte   HPOOC13 1986-1987
  byte   HPONO13 1988-1989
  byte   HPODE13 1990-1991
  byte   HPSJA13 1992-1993
  byte   HPSFE13 1994-1995
  byte   HPSMA13 1996-1997
  byte   HPSAP13 1998-1999
  byte   HPSMY13 2000-2001
  byte   HPSJU13 2002-2003
  byte   HPSJL13 2004-2005
  byte   HPSAU13 2006-2007
  byte   HPSSE13 2008-2009
  byte   HPSOC13 2010-2011
  byte   HPSNO13 2012-2013
  byte   HPSDE13 2014-2015
  byte   HPRJA13 2016-2017
  byte   HPRFE13 2018-2019
  byte   HPRMA13 2020-2021
  byte   HPRAP13 2022-2023
  byte   HPRMY13 2024-2025
  byte   HPRJU13 2026-2027
  byte   HPRJL13 2028-2029
  byte   HPRAU13 2030-2031
  byte   HPRSE13 2032-2033
  byte   HPROC13 2034-2035
  byte   HPRNO13 2036-2037
  byte   HPRDE13 2038-2039
  byte   INSJA13X 2040-2041
  byte   INSFE13X 2042-2043
  byte   INSMA13X 2044-2045
  byte   INSAP13X 2046-2047
  byte   INSMY13X 2048-2049
  byte   INSJU13X 2050-2051
  byte   INSJL13X 2052-2053
  byte   INSAU13X 2054-2055
  byte   INSSE13X 2056-2057
  byte   INSOC13X 2058-2059
  byte   INSNO13X 2060-2061
  byte   INSDE13X 2062-2063
  byte   PRVEV13 2064-2064
  byte   TRIEV13 2065-2065
  byte   MCREV13 2066-2066
  byte   MCDEV13 2067-2067
  byte   OPAEV13 2068-2068
  byte   OPBEV13 2069-2069
  byte   UNINS13 2070-2070
  byte   INSCOV13 2071-2071
  byte   INSURC13 2072-2072
  byte   TRIST31X 2073-2074
  byte   TRIST42X 2075-2076
  byte   TRIST13X 2077-2078
  byte   TRIPR31X 2079-2080
  byte   TRIPR42X 2081-2082
  byte   TRIPR13X 2083-2084
  byte   TRIEX31X 2085-2086
  byte   TRIEX42X 2087-2088
  byte   TRIEX13X 2089-2090
  byte   TRILI31X 2091-2092
  byte   TRILI42X 2093-2094
  byte   TRILI13X 2095-2096
  byte   TRICH31X 2097-2098
  byte   TRICH42X 2099-2100
  byte   TRICH13X 2101-2102
  byte   MCRPD31 2103-2104
  byte   MCRPD42 2105-2106
  byte   MCRPD13 2107-2108
  byte   MCRPD31X 2109-2110
  byte   MCRPD42X 2111-2112
  byte   MCRPD13X 2113-2114
  byte   MCRPB31 2115-2116
  byte   MCRPB42 2117-2118
  byte   MCRPB13 2119-2120
  byte   MCRPHO31 2121-2122
  byte   MCRPHO42 2123-2124
  byte   MCRPHO13 2125-2126
  byte   MCDHMO31 2127-2128
  byte   MCDHMO42 2129-2130
  byte   MCDHMO13 2131-2132
  byte   MCDMC31 2133-2134
  byte   MCDMC42 2135-2136
  byte   MCDMC13 2137-2138
  byte   PRVHMO31 2139-2140
  byte   PRVHMO42 2141-2142
  byte   PRVHMO13 2143-2144
  byte   PRVMNC31 2145-2146
  byte   PRVMNC42 2147-2148
  byte   PRVDRL31 2149-2150
  byte   PRVDRL42 2151-2152
  byte   PHMONP31 2153-2154
  byte   PHMONP42 2155-2156
  byte   PMNCNP31 2157-2158
  byte   PMNCNP42 2159-2160
  byte   PRDRNP31 2161-2162
  byte   PRDRNP42 2163-2164
  byte   FSAGT31 2165-2166
  byte   HASFSA31 2167-2168
  double FSAAMT31 2169-2176
  byte   PREVCOVR 2177-2178
  byte   COVRMM 2179-2180
  int    COVRYY 2181-2184
  byte   WASESTB 2185-2186
  byte   WASMCARE 2187-2188
  byte   WASMCAID 2189-2190
  byte   WASCHAMP 2191-2192
  byte   WASVA 2193-2194
  byte   WASPRIV 2195-2196
  byte   WASOTGOV 2197-2198
  byte   WASAFDC 2199-2200
  byte   WASSSI 2201-2202
  byte   WASSTAT1 2203-2204
  byte   WASSTAT2 2205-2206
  byte   WASSTAT3 2207-2208
  byte   WASSTAT4 2209-2210
  byte   WASOTHER 2211-2212
  byte   NOINSBEF 2213-2214
  byte   NOINSTM 2215-2216
  byte   NOINUNIT 2217-2218
  byte   MORECOVR 2219-2220
  byte   INSENDMM 2221-2222
  int    INSENDYY 2223-2226
  byte   TRICR31X 2227-2228
  byte   TRICR42X 2229-2230
  byte   TRICR53X 2231-2232
  byte   TRICR13X 2233-2234
  byte   TRIAT31X 2235-2236
  byte   TRIAT42X 2237-2238
  byte   TRIAT53X 2239-2240
  byte   TRIAT13X 2241-2242
  byte   MCAID31 2243-2244
  byte   MCAID42 2245-2246
  byte   MCAID53 2247-2248
  byte   MCAID13 2249-2250
  byte   MCAID31X 2251-2252
  byte   MCAID42X 2253-2254
  byte   MCAID53X 2255-2256
  byte   MCAID13X 2257-2258
  byte   MCARE31 2259-2260
  byte   MCARE42 2261-2262
  byte   MCARE53 2263-2264
  byte   MCARE13 2265-2266
  byte   MCARE31X 2267-2268
  byte   MCARE42X 2269-2270
  byte   MCARE53X 2271-2272
  byte   MCARE13X 2273-2274
  byte   MCDAT31X 2275-2276
  byte   MCDAT42X 2277-2278
  byte   MCDAT53X 2279-2280
  byte   MCDAT13X 2281-2282
  byte   OTPAAT31 2283-2284
  byte   OTPAAT42 2285-2286
  byte   OTPAAT53 2287-2288
  byte   OTPAAT13 2289-2290
  byte   OTPBAT31 2291-2292
  byte   OTPBAT42 2293-2294
  byte   OTPBAT53 2295-2296
  byte   OTPBAT13 2297-2298
  byte   OTPUBA31 2299-2300
  byte   OTPUBA42 2301-2302
  byte   OTPUBA53 2303-2304
  byte   OTPUBA13 2305-2306
  byte   OTPUBB31 2307-2308
  byte   OTPUBB42 2309-2310
  byte   OTPUBB53 2311-2312
  byte   OTPUBB13 2313-2314
  byte   PRIDK31 2315-2316
  byte   PRIDK42 2317-2318
  byte   PRIDK53 2319-2320
  byte   PRIDK13 2321-2322
  byte   PRIEU31 2323-2324
  byte   PRIEU42 2325-2326
  byte   PRIEU53 2327-2328
  byte   PRIEU13 2329-2330
  byte   PRING31 2331-2332
  byte   PRING42 2333-2334
  byte   PRING53 2335-2336
  byte   PRING13 2337-2338
  byte   PRIOG31 2339-2340
  byte   PRIOG42 2341-2342
  byte   PRIOG53 2343-2344
  byte   PRIOG13 2345-2346
  byte   PRIS31 2347-2348
  byte   PRIS42 2349-2350
  byte   PRIS53 2351-2352
  byte   PRIS13 2353-2354
  byte   PRIV31 2355-2356
  byte   PRIV42 2357-2358
  byte   PRIV53 2359-2360
  byte   PRIV13 2361-2362
  byte   PRIVAT31 2363-2364
  byte   PRIVAT42 2365-2366
  byte   PRIVAT53 2367-2368
  byte   PRIVAT13 2369-2370
  byte   PROUT31 2371-2372
  byte   PROUT42 2373-2374
  byte   PROUT53 2375-2376
  byte   PROUT13 2377-2378
  byte   PUB31X 2379-2380
  byte   PUB42X 2381-2382
  byte   PUB53X 2383-2384
  byte   PUB13X 2385-2386
  byte   PUBAT31X 2387-2388
  byte   PUBAT42X 2389-2390
  byte   PUBAT53X 2391-2392
  byte   PUBAT13X 2393-2394
  byte   INS31X 2395-2396
  byte   INS42X 2397-2398
  byte   INS53X 2399-2400
  byte   INS13X 2401-2402
  byte   INSAT31X 2403-2404
  byte   INSAT42X 2405-2406
  byte   INSAT53X 2407-2408
  byte   INSAT13X 2409-2410
  byte   STAPR31 2411-2412
  byte   STAPR42 2413-2414
  byte   STAPR53 2415-2416
  byte   STAPR13 2417-2418
  byte   STPRAT31 2419-2420
  byte   STPRAT42 2421-2422
  byte   STPRAT53 2423-2424
  byte   STPRAT13 2425-2426
  byte   DENTIN31 2427-2428
  byte   DENTIN42 2429-2430
  byte   DENTIN53 2431-2432
  byte   DNTINS31 2433-2434
  byte   DNTINS13 2435-2436
  byte   PMEDIN31 2437-2438
  byte   PMEDIN42 2439-2440
  byte   PMEDIN53 2441-2442
  byte   PMDINS31 2443-2444
  byte   PMDINS13 2445-2446
  byte   PMEDUP31 2447-2448
  byte   PMEDUP42 2449-2450
  byte   PMEDUP53 2451-2452
  byte   PMEDPY31 2453-2454
  byte   PMEDPY42 2455-2456
  byte   PMEDPY53 2457-2458
  int    PMEDPP31 2459-2462
  int    PMEDPP42 2463-2466
  long   TOTTCH13 2467-2473
  long   TOTEXP13 2474-2479
  long   TOTSLF13 2480-2485
  long   TOTMCR13 2486-2491
  long   TOTMCD13 2492-2497
  long   TOTPRV13 2498-2503
  long   TOTVA13 2504-2509
  long   TOTTRI13 2510-2515
  long   TOTOFD13 2516-2520
  long   TOTSTL13 2521-2525
  long   TOTWCP13 2526-2531
  long   TOTOPR13 2532-2536
  long   TOTOPU13 2537-2542
  long   TOTOSR13 2543-2547
  long   TOTPTR13 2548-2553
  long   TOTOTH13 2554-2559
  int    OBTOTV13 2560-2562
  long   OBVTCH13 2563-2568
  long   OBVEXP13 2569-2574
  long   OBVSLF13 2575-2579
  long   OBVMCR13 2580-2584
  long   OBVMCD13 2585-2590
  long   OBVPRV13 2591-2596
  long   OBVVA13 2597-2601
  long   OBVTRI13 2602-2606
  int    OBVOFD13 2607-2610
  long   OBVSTL13 2611-2615
  long   OBVWCP13 2616-2620
  long   OBVOPR13 2621-2625
  long   OBVOPU13 2626-2630
  long   OBVOSR13 2631-2635
  long   OBVPTR13 2636-2641
  long   OBVOTH13 2642-2646
  int    OBDRV13 2647-2649
  long   OBDTCH13 2650-2655
  long   OBDEXP13 2656-2661
  long   OBDSLF13 2662-2666
  long   OBDMCR13 2667-2671
  long   OBDMCD13 2672-2676
  long   OBDPRV13 2677-2682
  long   OBDVA13 2683-2687
  long   OBDTRI13 2688-2692
  int    OBDOFD13 2693-2696
  long   OBDSTL13 2697-2701
  long   OBDWCP13 2702-2706
  long   OBDOPR13 2707-2711
  long   OBDOPU13 2712-2716
  long   OBDOSR13 2717-2721
  long   OBDPTR13 2722-2727
  long   OBDOTH13 2728-2732
  int    OBOTHV13 2733-2735
  long   OBOTCH13 2736-2741
  long   OBOEXP13 2742-2747
  long   OBOSLF13 2748-2752
  long   OBOMCR13 2753-2757
  long   OBOMCD13 2758-2763
  long   OBOPRV13 2764-2768
  long   OBOVA13 2769-2773
  long   OBOTRI13 2774-2778
  int    OBOOFD13 2779-2782
  long   OBOSTL13 2783-2787
  long   OBOWCP13 2788-2792
  long   OBOOPR13 2793-2797
  int    OBOOPU13 2798-2801
  long   OBOOSR13 2802-2806
  long   OBOPTR13 2807-2811
  long   OBOOTH13 2812-2816
  int    OBCHIR13 2817-2819
  long   OBCTCH13 2820-2824
  long   OBCEXP13 2825-2829
  long   OBCSLF13 2830-2834
  int    OBCMCR13 2835-2838
  int    OBCMCD13 2839-2842
  int    OBCPRV13 2843-2846
  int    OBCVA13 2847-2849
  int    OBCTRI13 2850-2852
  byte   OBCOFD13 2853-2853
  int    OBCSTL13 2854-2856
  int    OBCWCP13 2857-2860
  int    OBCOPR13 2861-2864
  int    OBCOPU13 2865-2867
  long   OBCOSR13 2868-2872
  int    OBCPTR13 2873-2876
  long   OBCOTH13 2877-2881
  int    OBNURS13 2882-2884
  long   OBNTCH13 2885-2890
  long   OBNEXP13 2891-2895
  int    OBNSLF13 2896-2899
  long   OBNMCR13 2900-2904
  long   OBNMCD13 2905-2909
  long   OBNPRV13 2910-2914
  long   OBNVA13 2915-2919
  long   OBNTRI13 2920-2924
  int    OBNOFD13 2925-2928
  long   OBNSTL13 2929-2933
  int    OBNWCP13 2934-2937
  int    OBNOPR13 2938-2941
  int    OBNOPU13 2942-2945
  int    OBNOSR13 2946-2949
  long   OBNPTR13 2950-2954
  long   OBNOTH13 2955-2959
  byte   OBOPTO13 2960-2960
  int    OBETCH13 2961-2964
  int    OBEEXP13 2965-2968
  int    OBESLF13 2969-2972
  int    OBEMCR13 2973-2976
  int    OBEMCD13 2977-2980
  int    OBEPRV13 2981-2984
  int    OBEVA13 2985-2987
  int    OBETRI13 2988-2990
  byte   OBEOFD13 2991-2991
  int    OBESTL13 2992-2994
  byte   OBEWCP13 2995-2995
  int    OBEOPR13 2996-2998
  int    OBEOPU13 2999-3001
  int    OBEOSR13 3002-3004
  int    OBEPTR13 3005-3008
  int    OBEOTH13 3009-3011
  byte   OBASST13 3012-3013
  long   OBATCH13 3014-3019
  long   OBAEXP13 3020-3024
  int    OBASLF13 3025-3028
  int    OBAMCR13 3029-3032
  int    OBAMCD13 3033-3036
  int    OBAPRV13 3037-3040
  int    OBAVA13 3041-3044
  int    OBATRI13 3045-3047
  int    OBAOFD13 3048-3050
  int    OBASTL13 3051-3054
  int    OBAWCP13 3055-3058
  int    OBAOPR13 3059-3061
  int    OBAOPU13 3062-3064
  int    OBAOSR13 3065-3068
  int    OBAPTR13 3069-3072
  int    OBAOTH13 3073-3076
  int    OBTHER13 3077-3079
  long   OBTTCH13 3080-3085
  long   OBTEXP13 3086-3090
  int    OBTSLF13 3091-3094
  int    OBTMCR13 3095-3098
  long   OBTMCD13 3099-3103
  long   OBTPRV13 3104-3108
  long   OBTVA13 3109-3113
  int    OBTTRI13 3114-3117
  int    OBTOFD13 3118-3120
  long   OBTSTL13 3121-3125
  long   OBTWCP13 3126-3130
  long   OBTOPR13 3131-3135
  int    OBTOPU13 3136-3138
  int    OBTOSR13 3139-3142
  long   OBTPTR13 3143-3147
  long   OBTOTH13 3148-3152
  int    OPTOTV13 3153-3155
  long   OPTTCH13 3156-3161
  long   OPTEXP13 3162-3167
  long   OPTSLF13 3168-3172
  long   OPTMCR13 3173-3177
  long   OPTMCD13 3178-3182
  long   OPTPRV13 3183-3188
  long   OPTVA13 3189-3193
  int    OPTTRI13 3194-3197
  long   OPTOFD13 3198-3202
  long   OPTSTL13 3203-3207
  long   OPTWCP13 3208-3212
  long   OPTOPR13 3213-3217
  int    OPTOPU13 3218-3221
  long   OPTOSR13 3222-3226
  long   OPTPTR13 3227-3232
  long   OPTOTH13 3233-3237
  long   OPFTCH13 3238-3243
  long   OPFEXP13 3244-3249
  long   OPFSLF13 3250-3254
  long   OPFMCR13 3255-3259
  long   OPFMCD13 3260-3264
  long   OPFPRV13 3265-3270
  long   OPFVA13 3271-3275
  int    OPFTRI13 3276-3279
  long   OPFOFD13 3280-3284
  long   OPFSTL13 3285-3289
  long   OPFWCP13 3290-3294
  long   OPFOPR13 3295-3299
  int    OPFOPU13 3300-3303
  long   OPFOSR13 3304-3308
  long   OPFPTR13 3309-3314
  long   OPFOTH13 3315-3319
  long   OPDEXP13 3320-3324
  long   OPDTCH13 3325-3330
  int    OPDSLF13 3331-3334
  long   OPDMCR13 3335-3339
  long   OPDMCD13 3340-3344
  long   OPDPRV13 3345-3349
  int    OPDVA13 3350-3353
  int    OPDTRI13 3354-3357
  byte   OPDOFD13 3358-3358
  int    OPDSTL13 3359-3362
  int    OPDWCP13 3363-3366
  int    OPDOPR13 3367-3370
  int    OPDOPU13 3371-3374
  int    OPDOSR13 3375-3378
  long   OPDPTR13 3379-3383
  int    OPDOTH13 3384-3387
  byte   OPDRV13 3388-3389
  long   OPVTCH13 3390-3395
  long   OPVEXP13 3396-3401
  long   OPVSLF13 3402-3406
  long   OPVMCR13 3407-3411
  long   OPVMCD13 3412-3416
  long   OPVPRV13 3417-3422
  long   OPVVA13 3423-3427
  int    OPVTRI13 3428-3431
  long   OPVOFD13 3432-3436
  long   OPVSTL13 3437-3441
  long   OPVWCP13 3442-3446
  long   OPVOPR13 3447-3451
  int    OPVOPU13 3452-3455
  long   OPVOSR13 3456-3460
  long   OPVPTR13 3461-3466
  long   OPVOTH13 3467-3471
  long   OPSEXP13 3472-3476
  long   OPSTCH13 3477-3481
  int    OPSSLF13 3482-3485
  long   OPSMCR13 3486-3490
  long   OPSMCD13 3491-3495
  long   OPSPRV13 3496-3500
  int    OPSVA13 3501-3504
  int    OPSTRI13 3505-3508
  byte   OPSOFD13 3509-3509
  int    OPSSTL13 3510-3513
  int    OPSWCP13 3514-3517
  int    OPSOPR13 3518-3521
  int    OPSOPU13 3522-3525
  int    OPSOSR13 3526-3529
  long   OPSPTR13 3530-3534
  int    OPSOTH13 3535-3538
  int    OPOTHV13 3539-3541
  long   OPOTCH13 3542-3547
  long   OPOEXP13 3548-3552
  int    OPOSLF13 3553-3556
  long   OPOMCR13 3557-3561
  long   OPOMCD13 3562-3566
  long   OPOPRV13 3567-3571
  long   OPOVA13 3572-3576
  int    OPOTRI13 3577-3580
  long   OPOOFD13 3581-3585
  int    OPOSTL13 3586-3589
  int    OPOWCP13 3590-3593
  long   OPOOPR13 3594-3598
  int    OPOOPU13 3599-3602
  int    OPOOSR13 3603-3606
  long   OPOPTR13 3607-3611
  long   OPOOTH13 3612-3616
  long   OPPEXP13 3617-3621
  long   OPPTCH13 3622-3626
  int    OPPSLF13 3627-3630
  int    OPPMCR13 3631-3634
  int    OPPMCD13 3635-3638
  long   OPPPRV13 3639-3643
  int    OPPVA13 3644-3647
  int    OPPTRI13 3648-3651
  byte   OPPOFD13 3652-3652
  int    OPPSTL13 3653-3655
  int    OPPWCP13 3656-3659
  int    OPPOPR13 3660-3663
  int    OPPOPU13 3664-3666
  int    OPPOSR13 3667-3670
  long   OPPPTR13 3671-3675
  int    OPPOTH13 3676-3679
  int    AMCHIR13 3680-3682
  long   AMCTCH13 3683-3687
  long   AMCEXP13 3688-3692
  long   AMCSLF13 3693-3697
  int    AMCMCR13 3698-3701
  int    AMCMCD13 3702-3705
  int    AMCPRV13 3706-3709
  int    AMCVA13 3710-3712
  int    AMCTRI13 3713-3715
  byte   AMCOFD13 3716-3716
  int    AMCSTL13 3717-3719
  int    AMCWCP13 3720-3723
  int    AMCOPR13 3724-3727
  int    AMCOPU13 3728-3730
  long   AMCOSR13 3731-3735
  int    AMCPTR13 3736-3739
  long   AMCOTH13 3740-3744
  int    AMNURS13 3745-3747
  long   AMNTCH13 3748-3753
  long   AMNEXP13 3754-3758
  int    AMNSLF13 3759-3762
  long   AMNMCR13 3763-3767
  long   AMNMCD13 3768-3772
  long   AMNPRV13 3773-3777
  long   AMNVA13 3778-3782
  long   AMNTRI13 3783-3787
  int    AMNOFD13 3788-3791
  long   AMNSTL13 3792-3796
  int    AMNWCP13 3797-3800
  int    AMNOPR13 3801-3804
  int    AMNOPU13 3805-3808
  int    AMNOSR13 3809-3812
  long   AMNPTR13 3813-3817
  long   AMNOTH13 3818-3822
  byte   AMOPTO13 3823-3823
  int    AMETCH13 3824-3827
  int    AMEEXP13 3828-3831
  int    AMESLF13 3832-3835
  int    AMEMCR13 3836-3839
  int    AMEMCD13 3840-3843
  int    AMEPRV13 3844-3847
  int    AMEVA13 3848-3850
  int    AMETRI13 3851-3853
  int    AMEOFD13 3854-3856
  int    AMESTL13 3857-3859
  byte   AMEWCP13 3860-3860
  int    AMEOPR13 3861-3863
  int    AMEOPU13 3864-3866
  int    AMEOSR13 3867-3869
  int    AMEPTR13 3870-3873
  int    AMEOTH13 3874-3876
  byte   AMASST13 3877-3878
  long   AMATCH13 3879-3884
  long   AMAEXP13 3885-3889
  int    AMASLF13 3890-3893
  int    AMAMCR13 3894-3897
  int    AMAMCD13 3898-3901
  int    AMAPRV13 3902-3905
  int    AMAVA13 3906-3909
  int    AMATRI13 3910-3912
  int    AMAOFD13 3913-3915
  int    AMASTL13 3916-3919
  int    AMAWCP13 3920-3923
  int    AMAOPR13 3924-3926
  int    AMAOPU13 3927-3929
  int    AMAOSR13 3930-3933
  int    AMAPTR13 3934-3937
  int    AMAOTH13 3938-3941
  int    AMTHER13 3942-3944
  long   AMTTCH13 3945-3950
  long   AMTEXP13 3951-3955
  int    AMTSLF13 3956-3959
  int    AMTMCR13 3960-3963
  long   AMTMCD13 3964-3968
  long   AMTPRV13 3969-3973
  long   AMTVA13 3974-3978
  int    AMTTRI13 3979-3982
  int    AMTOFD13 3983-3985
  long   AMTSTL13 3986-3990
  long   AMTWCP13 3991-3995
  long   AMTOPR13 3996-4000
  int    AMTOPU13 4001-4004
  int    AMTOSR13 4005-4008
  long   AMTPTR13 4009-4013
  long   AMTOTH13 4014-4018
  byte   AMTOTC13 4019-4020
  byte   AMDRC13 4021-4022
  byte   ERTOT13 4023-4024
  long   ERTTCH13 4025-4030
  long   ERTEXP13 4031-4035
  int    ERTSLF13 4036-4039
  long   ERTMCR13 4040-4044
  long   ERTMCD13 4045-4049
  long   ERTPRV13 4050-4054
  long   ERTVA13 4055-4059
  int    ERTTRI13 4060-4063
  int    ERTOFD13 4064-4067
  long   ERTSTL13 4068-4072
  long   ERTWCP13 4073-4077
  long   ERTOPR13 4078-4082
  int    ERTOPU13 4083-4086
  long   ERTOSR13 4087-4091
  long   ERTPTR13 4092-4096
  long   ERTOTH13 4097-4101
  long   ERFTCH13 4102-4107
  long   ERFEXP13 4108-4112
  int    ERFSLF13 4113-4116
  long   ERFMCR13 4117-4121
  long   ERFMCD13 4122-4126
  long   ERFPRV13 4127-4131
  long   ERFVA13 4132-4136
  int    ERFTRI13 4137-4140
  int    ERFOFD13 4141-4144
  long   ERFSTL13 4145-4149
  long   ERFWCP13 4150-4154
  long   ERFOPR13 4155-4159
  int    ERFOPU13 4160-4163
  long   ERFOSR13 4164-4168
  long   ERFPTR13 4169-4173
  long   ERFOTH13 4174-4178
  int    ERDEXP13 4179-4182
  long   ERDTCH13 4183-4187
  int    ERDSLF13 4188-4191
  int    ERDMCR13 4192-4195
  int    ERDMCD13 4196-4199
  int    ERDPRV13 4200-4203
  int    ERDVA13 4204-4207
  int    ERDTRI13 4208-4211
  byte   ERDOFD13 4212-4212
  int    ERDSTL13 4213-4215
  int    ERDWCP13 4216-4219
  int    ERDOPR13 4220-4223
  int    ERDOPU13 4224-4226
  int    ERDOSR13 4227-4230
  int    ERDPTR13 4231-4234
  int    ERDOTH13 4235-4238
  byte   IPZERO13 4239-4239
  long   ZIFTCH13 4240-4245
  long   ZIFEXP13 4246-4250
  int    ZIFSLF13 4251-4254
  long   ZIFMCR13 4255-4259
  int    ZIFMCD13 4260-4263
  long   ZIFPRV13 4264-4268
  byte   ZIFVA13 4269-4269
  int    ZIFTRI13 4270-4273
  int    ZIFOFD13 4274-4276
  byte   ZIFSTL13 4277-4277
  byte   ZIFWCP13 4278-4278
  int    ZIFOPR13 4279-4282
  byte   ZIFOPU13 4283-4283
  int    ZIFOSR13 4284-4287
  long   ZIFPTR13 4288-4292
  int    ZIFOTH13 4293-4296
  int    ZIDEXP13 4297-4300
  long   ZIDTCH13 4301-4305
  int    ZIDSLF13 4306-4309
  int    ZIDMCR13 4310-4313
  int    ZIDMCD13 4314-4317
  int    ZIDPRV13 4318-4321
  byte   ZIDVA13 4322-4322
  int    ZIDTRI13 4323-4325
  byte   ZIDOFD13 4326-4326
  int    ZIDSTL13 4327-4330
  byte   ZIDWCP13 4331-4331
  int    ZIDOPR13 4332-4335
  int    ZIDOPU13 4336-4338
  int    ZIDOSR13 4339-4341
  int    ZIDPTR13 4342-4345
  int    ZIDOTH13 4346-4349
  byte   IPDIS13 4350-4351
  long   IPTEXP13 4352-4357
  long   IPTTCH13 4358-4364
  long   IPTSLF13 4365-4369
  long   IPTMCR13 4370-4375
  long   IPTMCD13 4376-4381
  long   IPTPRV13 4382-4387
  long   IPTVA13 4388-4393
  long   IPTTRI13 4394-4399
  int    IPTOFD13 4400-4402
  long   IPTSTL13 4403-4407
  long   IPTWCP13 4408-4412
  long   IPTOPR13 4413-4417
  long   IPTOPU13 4418-4423
  long   IPTOSR13 4424-4428
  long   IPTPTR13 4429-4434
  long   IPTOTH13 4435-4440
  long   IPFEXP13 4441-4446
  long   IPFTCH13 4447-4453
  long   IPFSLF13 4454-4458
  long   IPFMCR13 4459-4464
  long   IPFMCD13 4465-4470
  long   IPFPRV13 4471-4476
  long   IPFVA13 4477-4482
  long   IPFTRI13 4483-4488
  int    IPFOFD13 4489-4491
  long   IPFSTL13 4492-4496
  long   IPFWCP13 4497-4501
  long   IPFOPR13 4502-4506
  long   IPFOPU13 4507-4512
  long   IPFOSR13 4513-4517
  long   IPFPTR13 4518-4523
  long   IPFOTH13 4524-4529
  long   IPDEXP13 4530-4534
  long   IPDTCH13 4535-4540
  int    IPDSLF13 4541-4544
  long   IPDMCR13 4545-4549
  long   IPDMCD13 4550-4554
  long   IPDPRV13 4555-4559
  int    IPDVA13 4560-4563
  long   IPDTRI13 4564-4568
  byte   IPDOFD13 4569-4570
  int    IPDSTL13 4571-4574
  long   IPDWCP13 4575-4579
  long   IPDOPR13 4580-4584
  int    IPDOPU13 4585-4588
  long   IPDOSR13 4589-4593
  long   IPDPTR13 4594-4598
  long   IPDOTH13 4599-4603
  int    IPNGTD13 4604-4606
  byte   DVTOT13 4607-4608
  long   DVTTCH13 4609-4613
  long   DVTEXP13 4614-4618
  long   DVTSLF13 4619-4623
  int    DVTMCR13 4624-4627
  long   DVTMCD13 4628-4632
  long   DVTPRV13 4633-4637
  int    DVTVA13 4638-4641
  int    DVTTRI13 4642-4645
  int    DVTOFD13 4646-4649
  int    DVTSTL13 4650-4653
  int    DVTWCP13 4654-4657
  int    DVTOPR13 4658-4661
  int    DVTOPU13 4662-4665
  int    DVTOSR13 4666-4669
  long   DVTPTR13 4670-4674
  int    DVTOTH13 4675-4678
  byte   DVGEN13 4679-4680
  long   DVGTCH13 4681-4685
  long   DVGEXP13 4686-4690
  long   DVGSLF13 4691-4695
  int    DVGMCR13 4696-4699
  int    DVGMCD13 4700-4703
  long   DVGPRV13 4704-4708
  int    DVGVA13 4709-4712
  int    DVGTRI13 4713-4716
  int    DVGOFD13 4717-4720
  int    DVGSTL13 4721-4724
  int    DVGWCP13 4725-4727
  int    DVGOPR13 4728-4731
  int    DVGOPU13 4732-4735
  int    DVGOSR13 4736-4739
  long   DVGPTR13 4740-4744
  int    DVGOTH13 4745-4748
  byte   DVORTH13 4749-4750
  long   DVOTCH13 4751-4755
  long   DVOEXP13 4756-4760
  long   DVOSLF13 4761-4765
  int    DVOMCR13 4766-4769
  long   DVOMCD13 4770-4774
  long   DVOPRV13 4775-4779
  int    DVOVA13 4780-4783
  int    DVOTRI13 4784-4787
  int    DVOOFD13 4788-4790
  int    DVOSTL13 4791-4794
  byte   DVOWCP13 4795-4795
  int    DVOOPR13 4796-4799
  int    DVOOPU13 4800-4802
  byte   DVOOSR13 4803-4804
  long   DVOPTR13 4805-4809
  int    DVOOTH13 4810-4813
  int    HHTOTD13 4814-4816
  int    HHAGD13 4817-4819
  long   HHATCH13 4820-4825
  long   HHAEXP13 4826-4831
  long   HHASLF13 4832-4837
  long   HHAMCR13 4838-4842
  long   HHAMCD13 4843-4847
  long   HHAPRV13 4848-4853
  long   HHAVA13 4854-4858
  int    HHATRI13 4859-4862
  byte   HHAOFD13 4863-4863
  long   HHASTL13 4864-4868
  byte   HHAWCP13 4869-4869
  int    HHAOPR13 4870-4873
  int    HHAOPU13 4874-4877
  long   HHAOSR13 4878-4882
  long   HHAPTR13 4883-4888
  long   HHAOTH13 4889-4893
  int    HHINDD13 4894-4896
  long   HHNTCH13 4897-4901
  long   HHNEXP13 4902-4906
  long   HHNSLF13 4907-4911
  long   HHNMCD13 4912-4916
  long   HHNMCR13 4917-4921
  int    HHNPRV13 4922-4925
  byte   HHNVA13 4926-4927
  byte   HHNTRI13 4928-4928
  byte   HHNOFD13 4929-4929
  int    HHNSTL13 4930-4933
  byte   HHNWCP13 4934-4934
  byte   HHNOPR13 4935-4935
  int    HHNOPU13 4936-4938
  int    HHNOSR13 4939-4941
  int    HHNPTR13 4942-4945
  int    HHNOTH13 4946-4949
  int    HHINFD13 4950-4952
  long   VISEXP13 4953-4957
  long   VISTCH13 4958-4962
  int    VISSLF13 4963-4966
  int    VISMCR13 4967-4970
  int    VISMCD13 4971-4974
  long   VISPRV13 4975-4979
  int    VISVA13 4980-4982
  int    VISTRI13 4983-4986
  int    VISOFD13 4987-4989
  int    VISSTL13 4990-4992
  byte   VISWCP13 4993-4993
  long   VISOPR13 4994-4998
  int    VISOPU13 4999-5001
  int    VISOSR13 5002-5005
  long   VISPTR13 5006-5010
  long   VISOTH13 5011-5015
  long   OTHTCH13 5016-5020
  long   OTHEXP13 5021-5025
  long   OTHSLF13 5026-5030
  long   OTHMCR13 5031-5035
  long   OTHMCD13 5036-5040
  long   OTHPRV13 5041-5045
  int    OTHVA13 5046-5049
  int    OTHTRI13 5050-5053
  int    OTHOFD13 5054-5056
  int    OTHSTL13 5057-5060
  int    OTHWCP13 5061-5064
  int    OTHOPR13 5065-5068
  int    OTHOPU13 5069-5071
  int    OTHOSR13 5072-5075
  long   OTHPTR13 5076-5080
  int    OTHOTH13 5081-5084
  int    RXTOT13 5085-5087
  long   RXEXP13 5088-5093
  long   RXSLF13 5094-5098
  long   RXMCR13 5099-5104
  long   RXMCD13 5105-5110
  long   RXPRV13 5111-5116
  long   RXVA13 5117-5121
  long   RXTRI13 5122-5126
  int    RXOFD13 5127-5130
  long   RXSTL13 5131-5135
  long   RXWCP13 5136-5140
  long   RXOPR13 5141-5145
  long   RXOPU13 5146-5150
  int    RXOSR13 5151-5154
  long   RXPTR13 5155-5160
  long   RXOTH13 5161-5165
  double PERWT13F 5166-5177
  double FAMWT13F 5178-5189
  double FAMWT13C 5190-5201
  double SAQWT13F 5202-5213
  double DIABW13F 5214-5225
  int    VARSTR 5226-5229
  byte   VARPSU 5230-5230
using H163.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID13 "FAMILY ID (STUDENT MERGED IN) - 12/31/13";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR13 "RU LETTER AS OF 12/31/13";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE13 "RU SIZE AS OF 12/31/13";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS13 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/13";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE13 "RU SIZE INCLUDING STUDENT AS OF 12/31/13";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION13 "CENSUS REGION AS OF 12/31/13";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS13 "REFERENCE PERSON AS OF 12/31/13";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP13 "1ST RESPONDENT INDICATOR AS OF 12/31/13";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY13 "WAS RESPONDENT A PROXY AS OF 12/31/13";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM13 "2013 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY13 "2013 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP13 "INSCOPE - R5/3 START THROUGH 12/31/13";
label variable INSC1231 "INSCOPE STATUS ON 12/31/13";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2013";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND13 "ELIGIBILITY STATUS AS OF 12/31/13";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE13X "AGE AS OF 12/31/13 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEVER "RACE QUESTION VERSION ASKED";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY13X "MARITAL STATUS-12/31/13 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID13 "SPOUSE ID - 12/31/13";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN13 "MARITAL STATUS W/SPOUSE PRESENT-12/31/13";
label variable EDUYRDG "YEAR OF EDUCATION OR HIGHEST DEGREE";
label variable EDRECODE "EDUCATION RECODE (EDITED)";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU13X "STUDENT STATUS IF AGES 17-23 - 12/31/13";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL13X "RELATION TO REF PERS-12/31/13 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable ANYLMT13 "ANY LIMITATION IN P17R3,4,5/P18R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADESSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2013";
label variable DSFT1453 "DCS: HAD FEET CHECKED DURING 2014";
label variable DSFT1353 "DCS: HAD FEET CHECKED DURING 2013";
label variable DSFT1253 "DCS: HAD FEET CHECKED DURING 2012";
label variable DSFB1253 "DCS: HAD FEET CHECKED BEFORE 2012";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1453 "DCS: DILATED EYE EXAM IN 2014";
label variable DSEY1353 "DCS: DILATED EYE EXAM IN 2013";
label variable DSEY1253 "DCS: DILATED EYE EXAM IN 2012";
label variable DSEB1253 "DCS: DILATED EYE EXAM BEFORE 2012";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1453 "DCS: BLOOD CHOLESTEROL CHECKED IN 2014";
label variable DSCH1353 "DCS: BLOOD CHOLESTEROL CHECKED IN 2013";
label variable DSCH1253 "DCS: BLOOD CHOLESTEROL CHECKED IN 2012";
label variable DSCB1253 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2012";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1453 "DCS: GOT FLU VACCINATION IN 2014";
label variable DSFL1353 "DCS: GOT FLU VACCINATION IN 2013";
label variable DSFL1253 "DCS: GOT FLU VACCINATION IN 2012";
label variable DSVB1253 "DCS: GOT FLU VACCINATION BEFORE 2012";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R2";
label variable ENGCMF42 "AC02 WHOLE HH COMFORTABLE SPEAKNG ENG-R2";
label variable ENGSPK42 "AC02A NOT COMFORTABLE SPEAKNG ENGLISH-R2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R2";
label variable LIVEUS42 "AC04 NUMBER YEARS PERSON LIVED IN US-R2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-P17R2";
label variable PRVSPK42 "AC31 PROV SPEAKS PERSON S LANGUAGE-P18R2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/13";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable AFDC13 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR13 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL13 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT13 "PERSON S FILING STATUS";
label variable FILER13 "PRIMARY OR SECONDARY FILER";
label variable JTINRU13 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID13 "PID OF SECONDARY FILER";
label variable CLMDEP13 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT13 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU13 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD13 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM13 "TAX FORM PERSON WILL FILE";
label variable DEDUCT13 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED13 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP13 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT13 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST13 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN13 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL13 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP13X "PERSON S TOTAL INCOME";
label variable FAMINC13 "FAMILY S TOTAL INCOME";
label variable POVCAT13 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV13 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP13X "PERSON S WAGE INCOME";
label variable WAGIMP13 "WAGE IMPUTATION FLAG";
label variable BUSNP13X "PERSON S BUSINESS INCOME";
label variable BUSIMP13 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP13X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP13 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP13X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP13 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP13X "PERSON S INTEREST INCOME";
label variable INTIMP13 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP13X "PERSON S DIVIDEND INCOME";
label variable DIVIMP13 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP13X "PERSON S SALES INCOME";
label variable SALIMP13 "SALES INCOME IMPUTATION FLAG";
label variable PENSP13X "PERSON S PENSION INCOME";
label variable PENIMP13 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP13X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP13 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP13X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP13 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP13X "PERSON S VETERAN S INCOME";
label variable VETIMP13 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP13X "PERSON S IRA INCOME";
label variable IRAIMP13 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP13X "PERSON S ALIMONY INCOME";
label variable ALIIMP13 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP13X "PERSON S CHILD SUPPORT";
label variable CHLIMP13 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP13X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP13 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP13X "PERSON S SSI";
label variable SSIIMP13 "SSI IMPUTATION FLAG";
label variable PUBP13X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP13 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP13X "PERSON S OTHER INCOME";
label variable OTHIMP13 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA13X "COVERED BY TRICARE/CHAMPVA IN JAN13 (ED)";
label variable TRIFE13X "COVERED BY TRICARE/CHAMPVA IN FEB13 (ED)";
label variable TRIMA13X "COVERED BY TRICARE/CHAMPVA IN MAR13 (ED)";
label variable TRIAP13X "COVERED BY TRICARE/CHAMPVA IN APR13(ED)";
label variable TRIMY13X "COVERED BY TRICARE/CHAMPVA IN MAY13 (ED)";
label variable TRIJU13X "COVERED BY TRICARE/CHAMPVA IN JUN13 (ED)";
label variable TRIJL13X "COVERED BY TRICARE/CHAMPVA IN JUL13 (ED)";
label variable TRIAU13X "COVERED BY TRICARE/CHAMPVA IN AUG13 (ED)";
label variable TRISE13X "COVERED BY TRICARE/CHAMPVA IN SEP13 (ED)";
label variable TRIOC13X "COVERED BY TRICARE/CHAMPVA IN OCT13 (ED)";
label variable TRINO13X "COVERED BY TRICARE/CHAMPVA IN NOV13 (ED)";
label variable TRIDE13X "COVERED BY TRICARE/CHAMPVA IN DEC13 (ED)";
label variable MCRJA13 "COVERED BY MEDICARE IN JAN13";
label variable MCRFE13 "COVERED BY MEDICARE IN FEB13";
label variable MCRMA13 "COVERED BY MEDICARE IN MAR13";
label variable MCRAP13 "COVERED BY MEDICARE IN APR13";
label variable MCRMY13 "COVERED BY MEDICARE IN MAY13";
label variable MCRJU13 "COVERED BY MEDICARE IN JUN13";
label variable MCRJL13 "COVERED BY MEDICARE IN JUL13";
label variable MCRAU13 "COVERED BY MEDICARE IN AUG13";
label variable MCRSE13 "COVERED BY MEDICARE IN SEP13";
label variable MCROC13 "COVERED BY MEDICARE IN OCT13";
label variable MCRNO13 "COVERED BY MEDICARE IN NOV13";
label variable MCRDE13 "COVERED BY MEDICARE IN DEC13";
label variable MCRJA13X "COVERED BY MEDICARE IN JAN13 (ED)";
label variable MCRFE13X "COVERED BY MEDICARE IN FEB13 (ED)";
label variable MCRMA13X "COVERED BY MEDICARE IN MAR13 (ED)";
label variable MCRAP13X "COVERED BY MEDICARE IN APR13 (ED)";
label variable MCRMY13X "COVERED BY MEDICARE IN MAY13 (ED)";
label variable MCRJU13X "COVERED BY MEDICARE IN JUN13 (ED)";
label variable MCRJL13X "COVERED BY MEDICARE IN JUL13 (ED)";
label variable MCRAU13X "COVERED BY MEDICARE IN AUG13 (ED)";
label variable MCRSE13X "COVERED BY MEDICARE IN SEP13 (ED)";
label variable MCROC13X "COVERED BY MEDICARE IN OCT13 (ED)";
label variable MCRNO13X "COVERED BY MEDICARE IN NOV13 (ED)";
label variable MCRDE13X "COVERED BY MEDICARE IN DEC13 (ED)";
label variable MCDJA13 "COV BY MEDICAID OR SCHIP IN JAN13";
label variable MCDFE13 "COV BY MEDICAID OR SCHIP IN FEB13";
label variable MCDMA13 "COV BY MEDICAID OR SCHIP IN MAR13";
label variable MCDAP13 "COV BY MEDICAID OR SCHIP IN APR13";
label variable MCDMY13 "COV BY MEDICAID OR SCHIP IN MAY13";
label variable MCDJU13 "COV BY MEDICAID OR SCHIP IN JUN13";
label variable MCDJL13 "COV BY MEDICAID OR SCHIP IN JUL13";
label variable MCDAU13 "COV BY MEDICAID OR SCHIP IN AUG13";
label variable MCDSE13 "COV BY MEDICAID OR SCHIP IN SEP13";
label variable MCDOC13 "COV BY MEDICAID OR SCHIP IN OCT13";
label variable MCDNO13 "COV BY MEDICAID OR SCHIP IN NOV13";
label variable MCDDE13 "COV BY MEDICAID OR SCHIP IN DEC13";
label variable MCDJA13X "COV BY MEDICAID OR SCHIP IN JAN13 (ED)";
label variable MCDFE13X "COV BY MEDICAID OR SCHIP IN FEB13 (ED)";
label variable MCDMA13X "COV BY MEDICAID OR SCHIP IN MAR13 (ED)";
label variable MCDAP13X "COV BY MEDICAID OR SCHIP IN APR13 (ED)";
label variable MCDMY13X "COV BY MEDICAID OR SCHIP IN MAY13 (ED)";
label variable MCDJU13X "COV BY MEDICAID OR SCHIP IN JUN13 (ED)";
label variable MCDJL13X "COV BY MEDICAID OR SCHIP IN JUL13 (ED)";
label variable MCDAU13X "COV BY MEDICAID OR SCHIP IN AUG13 (ED)";
label variable MCDSE13X "COV BY MEDICAID OR SCHIP IN SEP13 (ED)";
label variable MCDOC13X "COV BY MEDICAID OR SCHIP IN OCT13 (ED)";
label variable MCDNO13X "COV BY MEDICAID OR SCHIP IN NOV13 (ED)";
label variable MCDDE13X "COV BY MEDICAID OR SCHIP IN DEC13 (ED)";
label variable OPAJA13 "COV BY OTHER PUBLIC A INS IN JAN13";
label variable OPAFE13 "COV BY OTHER PUBLIC A INS IN FEB13";
label variable OPAMA13 "COV BY OTHER PUBLIC A INS IN MAR13";
label variable OPAAP13 "COV BY OTHER PUBLIC A INS IN APR13";
label variable OPAMY13 "COV BY OTHER PUBLIC A INS IN MAY13";
label variable OPAJU13 "COV BY OTHER PUBLIC A INS IN JUN13";
label variable OPAJL13 "COV BY OTHER PUBLIC A INS IN JUL13";
label variable OPAAU13 "COV BY OTHER PUBLIC A INS IN AUG13";
label variable OPASE13 "COV BY OTHER PUBLIC A INS IN SEP13";
label variable OPAOC13 "COV BY OTHER PUBLIC A INS IN OCT13";
label variable OPANO13 "COV BY OTHER PUBLIC A INS IN NOV13";
label variable OPADE13 "COV BY OTHER PUBLIC A INS IN DEC13";
label variable OPBJA13 "COV BY OTHER PUBLIC B INS IN JAN13";
label variable OPBFE13 "COV BY OTHER PUBLIC B INS IN FEB13";
label variable OPBMA13 "COV BY OTHER PUBLIC B INS IN MAR13";
label variable OPBAP13 "COV BY OTHER PUBLIC B INS IN APR13";
label variable OPBMY13 "COV BY OTHER PUBLIC B INS IN MAY13";
label variable OPBJU13 "COV BY OTHER PUBLIC B INS IN JUN13";
label variable OPBJL13 "COV BY OTHER PUBLIC B INS IN JUL13";
label variable OPBAU13 "COV BY OTHER PUBLIC B INS IN AUG13";
label variable OPBSE13 "COV BY OTHER PUBLIC B INS IN SEP13";
label variable OPBOC13 "COV BY OTHER PUBLIC B INS IN OCT13";
label variable OPBNO13 "COV BY OTHER PUBLIC B INS IN NOV13";
label variable OPBDE13 "COV BY OTHER PUBLIC B INS IN DEC13";
label variable STAJA13 "COVERED BY OTHER STATE PROG IN JAN13";
label variable STAFE13 "COVERED BY OTHER STATE PROG IN FEB13";
label variable STAMA13 "COVERED BY OTHER STATE PROG IN MAR13";
label variable STAAP13 "COVERED BY OTHER STATE PROG IN APR13";
label variable STAMY13 "COVERED BY OTHER STATE PROG IN MAY13";
label variable STAJU13 "COVERED BY OTHER STATE PROG IN JUN13";
label variable STAJL13 "COVERED BY OTHER STATE PROG IN JUL13";
label variable STAAU13 "COVERED BY OTHER STATE PROG IN AUG13";
label variable STASE13 "COVERED BY OTHER STATE PROG IN SEP13";
label variable STAOC13 "COVERED BY OTHER STATE PROG IN OCT13";
label variable STANO13 "COVERED BY OTHER STATE PROG IN NOV13";
label variable STADE13 "COVERED BY OTHER STATE PROG IN DEC13";
label variable PUBJA13X "COVR BY ANY PUBLIC INS IN JAN13 (ED)";
label variable PUBFE13X "COVR BY ANY PUBLIC INS IN FEB13 (ED)";
label variable PUBMA13X "COVR BY ANY PUBLIC INS IN MAR13 (ED)";
label variable PUBAP13X "COVR BY ANY PUBLIC INS IN APR13 (ED)";
label variable PUBMY13X "COVR BY ANY PUBLIC INS IN MAY13 (ED)";
label variable PUBJU13X "COVR BY ANY PUBLIC INS IN JUN13 (ED)";
label variable PUBJL13X "COVR BY ANY PUBLIC INS IN JUL13 (ED)";
label variable PUBAU13X "COVR BY ANY PUBLIC INS IN AUG13 (ED)";
label variable PUBSE13X "COVR BY ANY PUBLIC INS IN SEP13 (ED)";
label variable PUBOC13X "COVR BY ANY PUBLIC INS IN OCT13 (ED)";
label variable PUBNO13X "COVR BY ANY PUBLIC INS IN NOV13 (ED)";
label variable PUBDE13X "COVR BY ANY PUBLIC INS IN DEC13 (ED)";
label variable PEGJA13 "COVERED BY EMPL UNION INS IN JAN13";
label variable PEGFE13 "COVERED BY EMPL UNION INS IN FEB13";
label variable PEGMA13 "COVERED BY EMPL UNION INS IN MAR13";
label variable PEGAP13 "COVERED BY EMPL UNION INS IN APR13";
label variable PEGMY13 "COVERED BY EMPL UNION INS IN MAY13";
label variable PEGJU13 "COVERED BY EMPL UNION INS IN JUN13";
label variable PEGJL13 "COVERED BY EMPL UNION INS IN JUL13";
label variable PEGAU13 "COVERED BY EMPL UNION INS IN AUG13";
label variable PEGSE13 "COVERED BY EMPL UNION INS IN SEP13";
label variable PEGOC13 "COVERED BY EMPL UNION INS IN OCT13";
label variable PEGNO13 "COVERED BY EMPL UNION INS IN NOV13";
label variable PEGDE13 "COVERED BY EMPL UNION INS IN DEC13";
label variable PDKJA13 "COVR BY PRIV INS (SOURCE UNKNWN) JAN13";
label variable PDKFE13 "COVR BY PRIV INS (SOURCE UNKNWN) FEB13";
label variable PDKMA13 "COVR BY PRIV INS (SOURCE UNKNWN) MAR13";
label variable PDKAP13 "COVR BY PRIV INS (SOURCE UNKNWN) APR13";
label variable PDKMY13 "COVR BY PRIV INS (SOURCE UNKNWN) MAY13";
label variable PDKJU13 "COVR BY PRIV INS (SOURCE UNKNWN) JUN13";
label variable PDKJL13 "COVR BY PRIV INS (SOURCE UNKNWN) JUL13";
label variable PDKAU13 "COVR BY PRIV INS (SOURCE UNKNWN) AUG13";
label variable PDKSE13 "COVR BY PRIV INS (SOURCE UNKNWN) SEP13";
label variable PDKOC13 "COVR BY PRIV INS (SOURCE UNKNWN) OCT13";
label variable PDKNO13 "COVR BY PRIV INS (SOURCE UNKNWN) NOV13";
label variable PDKDE13 "COVR BY PRIV INS (SOURCE UNKNWN) DEC13";
label variable PNGJA13 "COVERED BY NONGROUP INS IN JAN13";
label variable PNGFE13 "COVERED BY NONGROUP INS IN FEB13";
label variable PNGMA13 "COVERED BY NONGROUP INS IN MAR13";
label variable PNGAP13 "COVERED BY NONGROUP INS IN APR13";
label variable PNGMY13 "COVERED BY NONGROUP INS IN MAY13";
label variable PNGJU13 "COVERED BY NONGROUP INS IN JUN13";
label variable PNGJL13 "COVERED BY NONGROUP INS IN JUL13";
label variable PNGAU13 "COVERED BY NONGROUP INS IN AUG13";
label variable PNGSE13 "COVERED BY NONGROUP INS IN SEP13";
label variable PNGOC13 "COVERED BY NONGROUP INS IN OCT13";
label variable PNGNO13 "COVERED BY NONGROUP INS IN NOV13";
label variable PNGDE13 "COVERED BY NONGROUP INS IN DEC13";
label variable POGJA13 "COVERED BY OTHER GROUP INS IN JAN13";
label variable POGFE13 "COVERED BY OTHER GROUP INS IN FEB13";
label variable POGMA13 "COVERED BY OTHER GROUP INS IN MAR13";
label variable POGAP13 "COVERED BY OTHER GROUP INS IN APR13";
label variable POGMY13 "COVERED BY OTHER GROUP INS IN MAY13";
label variable POGJU13 "COVERED BY OTHER GROUP INS IN JUN13";
label variable POGJL13 "COVERED BY OTHER GROUP INS IN JUL13";
label variable POGAU13 "COVERED BY OTHER GROUP INS IN AUG13";
label variable POGSE13 "COVERED BY OTHER GROUP INS IN SEP13";
label variable POGOC13 "COVERED BY OTHER GROUP INS IN OCT13";
label variable POGNO13 "COVERED BY OTHER GROUP INS IN NOV13";
label variable POGDE13 "COVERED BY OTHER GROUP INS IN DEC13";
label variable PRSJA13 "COVERED BY SELF-EMP-1 INS IN JAN13";
label variable PRSFE13 "COVERED BY SELF-EMP-1 INS IN FEB13";
label variable PRSMA13 "COVERED BY SELF-EMP-1 INS IN MAR13";
label variable PRSAP13 "COVERED BY SELF-EMP-1 INS IN APR13";
label variable PRSMY13 "COVERED BY SELF-EMP-1 INS IN MAY13";
label variable PRSJU13 "COVERED BY SELF-EMP-1 INS IN JUN13";
label variable PRSJL13 "COVERED BY SELF-EMP-1 INS IN JUL13";
label variable PRSAU13 "COVERED BY SELF-EMP-1 INS IN AUG13";
label variable PRSSE13 "COVERED BY SELF-EMP-1 INS IN SEP13";
label variable PRSOC13 "COVERED BY SELF-EMP-1 INS IN OCT13";
label variable PRSNO13 "COVERED BY SELF-EMP-1 INS IN NOV13";
label variable PRSDE13 "COVERED BY SELF-EMP-1 INS IN DEC13";
label variable POUJA13 "COVERED BY HOLDER OUTSIDE OF RU IN JAN13";
label variable POUFE13 "COVERED BY HOLDER OUTSIDE OF RU IN FEB13";
label variable POUMA13 "COVERED BY HOLDER OUTSIDE OF RU IN MAR13";
label variable POUAP13 "COVERED BY HOLDER OUTSIDE OF RU IN APR13";
label variable POUMY13 "COVERED BY HOLDER OUTSIDE OF RU IN MAY13";
label variable POUJU13 "COVERED BY HOLDER OUTSIDE OF RU IN JUN13";
label variable POUJL13 "COVERED BY HOLDER OUTSIDE OF RU IN JUL13";
label variable POUAU13 "COVERED BY HOLDER OUTSIDE OF RU IN AUG13";
label variable POUSE13 "COVERED BY HOLDER OUTSIDE OF RU IN SEP13";
label variable POUOC13 "COVERED BY HOLDER OUTSIDE OF RU IN OCT13";
label variable POUNO13 "COVERED BY HOLDER OUTSIDE OF RU IN NOV13";
label variable POUDE13 "COVERED BY HOLDER OUTSIDE OF RU IN DEC13";
label variable PRIJA13 "COVERED BY PRIVATE INS IN JAN13";
label variable PRIFE13 "COVERED BY PRIVATE INS IN FEB13";
label variable PRIMA13 "COVERED BY PRIVATE INS IN MAR13";
label variable PRIAP13 "COVERED BY PRIVATE INS IN APR13";
label variable PRIMY13 "COVERED BY PRIVATE INS IN MAY13";
label variable PRIJU13 "COVERED BY PRIVATE INS IN JUN13";
label variable PRIJL13 "COVERED BY PRIVATE INS IN JUL13";
label variable PRIAU13 "COVERED BY PRIVATE INS IN AUG13";
label variable PRISE13 "COVERED BY PRIVATE INS IN SEP13";
label variable PRIOC13 "COVERED BY PRIVATE INS IN OCT13";
label variable PRINO13 "COVERED BY PRIVATE INS IN NOV13";
label variable PRIDE13 "COVERED BY PRIVATE INS IN DEC13";
label variable HPEJA13 "HOLDER OF EMPL UNION INS IN JAN13";
label variable HPEFE13 "HOLDER OF EMPL UNION INS IN FEB13";
label variable HPEMA13 "HOLDER OF EMPL UNION INS IN MAR13";
label variable HPEAP13 "HOLDER OF EMPL UNION INS IN APR13";
label variable HPEMY13 "HOLDER OF EMPL UNION INS IN MAY13";
label variable HPEJU13 "HOLDER OF EMPL UNION INS IN JUN13";
label variable HPEJL13 "HOLDER OF EMPL UNION INS IN JUL13";
label variable HPEAU13 "HOLDER OF EMPL UNION INS IN AUG13";
label variable HPESE13 "HOLDER OF EMPL UNION INS IN SEP13";
label variable HPEOC13 "HOLDER OF EMPL UNION INS IN OCT13";
label variable HPENO13 "HOLDER OF EMPL UNION INS IN NOV13";
label variable HPEDE13 "HOLDER OF EMPL UNION INS IN DEC13";
label variable HPDJA13 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN13";
label variable HPDFE13 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB13";
label variable HPDMA13 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR13";
label variable HPDAP13 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR13";
label variable HPDMY13 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY13";
label variable HPDJU13 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN13";
label variable HPDJL13 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL13";
label variable HPDAU13 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG13";
label variable HPDSE13 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP13";
label variable HPDOC13 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT13";
label variable HPDNO13 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV13";
label variable HPDDE13 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC13";
label variable HPNJA13 "HOLDER OF NONGROUP INS IN JAN13";
label variable HPNFE13 "HOLDER OF NONGROUP INS IN FEB13";
label variable HPNMA13 "HOLDER OF NONGROUP INS IN MAR13";
label variable HPNAP13 "HOLDER OF NONGROUP INS IN APR13";
label variable HPNMY13 "HOLDER OF NONGROUP INS IN MAY13";
label variable HPNJU13 "HOLDER OF NONGROUP INS IN JUN13";
label variable HPNJL13 "HOLDER OF NONGROUP INS IN JUL13";
label variable HPNAU13 "HOLDER OF NONGROUP INS IN AUG13";
label variable HPNSE13 "HOLDER OF NONGROUP INS IN SEP13";
label variable HPNOC13 "HOLDER OF NONGROUP INS IN OCT13";
label variable HPNNO13 "HOLDER OF NONGROUP INS IN NOV13";
label variable HPNDE13 "HOLDER OF NONGROUP INS IN DEC13";
label variable HPOJA13 "HOLDER OF OTHER GROUP INS IN JAN13";
label variable HPOFE13 "HOLDER OF OTHER GROUP INS IN FEB13";
label variable HPOMA13 "HOLDER OF OTHER GROUP INS IN MAR13";
label variable HPOAP13 "HOLDER OF OTHER GROUP INS IN APR13";
label variable HPOMY13 "HOLDER OF OTHER GROUP INS IN MAY13";
label variable HPOJU13 "HOLDER OF OTHER GROUP INS IN JUN13";
label variable HPOJL13 "HOLDER OF OTHER GROUP INS IN JUL13";
label variable HPOAU13 "HOLDER OF OTHER GROUP INS IN AUG13";
label variable HPOSE13 "HOLDER OF OTHER GROUP INS IN SEP13";
label variable HPOOC13 "HOLDER OF OTHER GROUP INS IN OCT13";
label variable HPONO13 "HOLDER OF OTHER GROUP INS IN NOV13";
label variable HPODE13 "HOLDER OF OTHER GROUP INS IN DEC13";
label variable HPSJA13 "HOLDER OF SELF-EMP-1 INS IN JAN13";
label variable HPSFE13 "HOLDER OF SELF-EMP-1 INS IN FEB13";
label variable HPSMA13 "HOLDER OF SELF-EMP-1 INS IN MAR13";
label variable HPSAP13 "HOLDER OF SELF-EMP-1 INS IN APR13";
label variable HPSMY13 "HOLDER OF SELF-EMP-1 INS IN MAY13";
label variable HPSJU13 "HOLDER OF SELF-EMP-1 INS IN JUN13";
label variable HPSJL13 "HOLDER OF SELF-EMP-1 INS IN JUL13";
label variable HPSAU13 "HOLDER OF SELF-EMP-1 INS IN AUG13";
label variable HPSSE13 "HOLDER OF SELF-EMP-1 INS IN SEP13";
label variable HPSOC13 "HOLDER OF SELF-EMP-1 INS IN OCT13";
label variable HPSNO13 "HOLDER OF SELF-EMP-1 INS IN NOV13";
label variable HPSDE13 "HOLDER OF SELF-EMP-1 INS IN DEC13";
label variable HPRJA13 "HOLDER OF PRIVATE INSURANCE IN JAN13";
label variable HPRFE13 "HOLDER OF PRIVATE INSURANCE IN FEB13";
label variable HPRMA13 "HOLDER OF PRIVATE INSURANCE IN MAR13";
label variable HPRAP13 "HOLDER OF PRIVATE INSURANCE IN APR13";
label variable HPRMY13 "HOLDER OF PRIVATE INSURANCE IN MAY13";
label variable HPRJU13 "HOLDER OF PRIVATE INSURANCE IN JUN13";
label variable HPRJL13 "HOLDER OF PRIVATE INSURANCE IN JUL13";
label variable HPRAU13 "HOLDER OF PRIVATE INSURANCE IN AUG13";
label variable HPRSE13 "HOLDER OF PRIVATE INSURANCE IN SEP13";
label variable HPROC13 "HOLDER OF PRIVATE INSURANCE IN OCT13";
label variable HPRNO13 "HOLDER OF PRIVATE INSURANCE IN NOV13";
label variable HPRDE13 "HOLDER OF PRIVATE INSURANCE IN DEC13";
label variable INSJA13X "COVR BY HOSP/MED INS IN JAN13 (ED)";
label variable INSFE13X "COVR BY HOSP/MED INS IN FEB13 (ED)";
label variable INSMA13X "COVR BY HOSP/MED INS IN MAR13 (ED)";
label variable INSAP13X "COVR BY HOSP/MED INS IN APR13 (ED)";
label variable INSMY13X "COVR BY HOSP/MED INS IN MAY13 (ED)";
label variable INSJU13X "COVR BY HOSP/MED INS IN JUN13 (ED)";
label variable INSJL13X "COVR BY HOSP/MED INS IN JUL13 (ED)";
label variable INSAU13X "COVR BY HOSP/MED INS IN AUG13 (ED)";
label variable INSSE13X "COVR BY HOSP/MED INS IN SEP13 (ED)";
label variable INSOC13X "COVR BY HOSP/MED INS IN OCT13 (ED)";
label variable INSNO13X "COVR BY HOSP/MED INS IN NOV13 (ED)";
label variable INSDE13X "COVR BY HOSP/MED INS IN DEC13 (ED)";
label variable PRVEV13 "EVER HAVE PRIVATE INSURANCE DURING 13";
label variable TRIEV13 "EVER HAVE TRICARE/CHAMPVA DURING 13";
label variable MCREV13 "EVER HAVE MEDICARE DURING 13 (ED)";
label variable MCDEV13 "EVER HAVE MEDICAID/SCHIP DURING 13 (ED)";
label variable OPAEV13 "EVER HAVE OTHER PUBLIC A INS DURING 13";
label variable OPBEV13 "EVER HAVE OTHER PUBLIC B INS DURING 13";
label variable UNINS13 "UNINSURED ALL OF 13";
label variable INSCOV13 "HEALTH INSURANCE COVERAGE INDICATOR 13";
label variable INSURC13 "FULL YEAR INSURANCE COVERAGE STATUS 2013";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST13X "COVERED BY TRICARE STANDARD - 12/31/13";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR13X "COVERED BY TRICARE PRIME - 12/31/13";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX13X "COVERED BY TRICARE EXTRA - 12/31/13";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI13X "COVERED BY TRICARE FOR LIFE - 12/31/13";
label variable TRICH31X "COVERED BY CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - R4/2";
label variable TRICH13X "COVERED BY TRICARE CHAMPVA - 12/31/13";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD13 "COV BY MEDICARE PMED BENEFIT - 12/31/13";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD13X "COV BY MCARE PMED BENEFIT-12/31/13 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB13 "COV BY MEDICARE PART B - 12/31/13";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO13 "COV BY MEDICARE MANAGED CARE - 12/31/13";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO13 "COVRED BY MEDICAID OR SCHIP HMO-12/31/13";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC13 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/13";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO13 "COVERED BY PRIVATE HMO - 12/31/13";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 18 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 18 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 18 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 18 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 18 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 18 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 18 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 18 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 18 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 18 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 18 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 18 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 18 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 18 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 18 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 18 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 18 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 18 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 18 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 18 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 18 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 18 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 18 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR13X "COV BY TRICR/CHAMV - 12/31/13 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT13X "ANY TIME COV TRICARE/CHAMPVA - 12/31/13";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID13 "COV BY MEDICAID OR SCHIP - 12/31/13";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID13X "COV BY MEDICAID OR SCHIP - 12/31/13 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE13 "COV BY MEDICARE - 12/31/13";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE13X "COV BY MEDICARE - 12/31/13 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT13X "ANY TIME COV MEDICAID OR SCHIP-12/31/13";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT13 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/13";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT13 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/13";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA13 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/13";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB13 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/13";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK13 "COV BY PRIV INS (DK PLAN) - 12/31/13";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU13 "COV BY EMPL/UNION GRP INS - 12/31/13";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING13 "COV BY NON-GROUP INS - 12/31/13";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG13 "COV BY OTHER GROUP INS - 12/31/13";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS13 "COV BY SELF-EMP-1 INS - 12/31/13";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV13 "COV BY PRIV HLTH INS - 12/31/13";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT13 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/13";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT13 "COV BY SOMEONE OUT OF RU - 12/31/13";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB13X "COV BY PUBLIC INS - 12/31/13 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT13X "ANY TIME COV BY PUBLIC - 12/31/13";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS13X "INSURED - 12/31/13 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT13X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/13";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR13 "COV BY STATE-SPEC PROG - 12/31/13";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT13 "ANY TIME COV BY STATE INS - 12/31/13";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 13";
label variable DNTINS13 "DENTAL INS - R5/R3 UNTIL 12/31/13";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS RD 3/1 IN 13";
label variable PMDINS13 "PMED INS - R5/R3 UNTIL 12/31/13";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDPP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDPP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable TOTTCH13 "TOTAL HEALTH CARE CHARGES 13, EXCL RX";
label variable TOTEXP13 "TOTAL HEALTH CARE EXP 13";
label variable TOTSLF13 "TOTAL AMT PAID BY SELF/FAMILY 13";
label variable TOTMCR13 "TOTAL AMT PAID BY MEDICARE 13";
label variable TOTMCD13 "TOTAL AMT PAID BY MEDICAID 13";
label variable TOTPRV13 "TOTAL AMT PAID BY PRIVATE INS 13";
label variable TOTVA13 "TOTAL AMT PAID BY VA/CHAMPVA 13";
label variable TOTTRI13 "TOTAL AMT PAID BY TRICARE 13";
label variable TOTOFD13 "TOTAL AMT PAID BY OTHER FEDERAL 13";
label variable TOTSTL13 "TOTAL AMT PAID BY OTH ST/LOCAL 13";
label variable TOTWCP13 "TOTAL AMT PAID BY WORKERS COMP 13";
label variable TOTOPR13 "TOTAL AMT PAID BY OTHER PRIVATE 13";
label variable TOTOPU13 "TOTAL AMT PAID BY OTHER PUBLIC 13";
label variable TOTOSR13 "TOTAL AMT PAID BY OTHER SOURCES 13";
label variable TOTPTR13 "TOTAL AMT PAID BY PRV & TRI 13";
label variable TOTOTH13 "TOTAL AMT PAID BY OTH COMBINED 13";
label variable OBTOTV13 "# OFFICE-BASED PROVIDER VISITS 13";
label variable OBVTCH13 "OFFICE-BASED PROVIDER VISIT CHARGES 13";
label variable OBVEXP13 "TOTAL OFFICE-BASED EXP 13";
label variable OBVSLF13 "ALL OFFICE VISITS - SELF/FAMILY AMT 13";
label variable OBVMCR13 "ALL OFFICE VISITS - MEDICARE AMT 13";
label variable OBVMCD13 "ALL OFFICE VISITS - MEDICAID AMT 13";
label variable OBVPRV13 "ALL OFFICE VISITS - PRIVATE INS AMT 13";
label variable OBVVA13 "ALL OFFICE VISITS-VA/CHAMPVA AMT 13";
label variable OBVTRI13 "ALL OFFICE VISITS-TRICARE AMT 13";
label variable OBVOFD13 "ALL OFFICE VISITS-OTHER FEDERAL AMT 13";
label variable OBVSTL13 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 13";
label variable OBVWCP13 "ALL OFFICE VISITS - WORKERS COMP AMT 13";
label variable OBVOPR13 "ALL OFFICE VISITS - OTH PRIVATE AMT 13";
label variable OBVOPU13 "ALL OFFICE VISITS - OTH PUBLIC AMT 13";
label variable OBVOSR13 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 13";
label variable OBVPTR13 "ALL OFFICE VISITS - PRV & TRI AMT 13";
label variable OBVOTH13 "ALL OFFICE VISITS - OTH COMBINED AMT 13";
label variable OBDRV13 "# OFFICE-BASED PHYSICIAN VISITS 13";
label variable OBDTCH13 "OFFICE-BASED PHYSICIAN VISIT CHARGES 13";
label variable OBDEXP13 "TOTAL OFF-BASED DR EXP 13";
label variable OBDSLF13 "DR OFFICE VISITS - SELF/FAMILY AMT 13";
label variable OBDMCR13 "DR OFFICE VISITS - MEDICARE AMT 13";
label variable OBDMCD13 "DR OFFICE VISITS - MEDICAID AMT 13";
label variable OBDPRV13 "DR OFFICE VISITS - PRIVATE INS AMT 13";
label variable OBDVA13 "DR OFFICE VISITS - VA/CHAMPVA AMT 13";
label variable OBDTRI13 "DR OFFICE VISITS - TRICARE AMT 13";
label variable OBDOFD13 "DR OFFICE VISITS - OTHER FEDERAL AMT 13";
label variable OBDSTL13 "DR OFFICE VISITS - OTH ST/LOCAL AMT 13";
label variable OBDWCP13 "DR OFFICE VISITS - WORKERS COMP AMT 13";
label variable OBDOPR13 "DR OFFICE VISITS - OTH PRIVATE AMT 13";
label variable OBDOPU13 "DR OFFICE VISITS - OTH PUBLIC AMT 13";
label variable OBDOSR13 "DR OFF VSTS - OTH UNCLASS SRCE AMT 13";
label variable OBDPTR13 "DR OFFICE VISITS - PRV & TRI AMT 13";
label variable OBDOTH13 "DR OFFICE VISITS - OTH COMBINED AMT 13";
label variable OBOTHV13 "# OFFICE-BASED NON-PHYSICAN VISITS 13";
label variable OBOTCH13 "OFFICE-BASED NON-DR VISIT CHARGES 13";
label variable OBOEXP13 "TOTAL OFF-BASED NON-DR EXP 13";
label variable OBOSLF13 "NON-DR OFF VISTS - SELF/FAMILY AMT 13";
label variable OBOMCR13 "NON-DR OFF VISTS - MEDICARE AMT 13";
label variable OBOMCD13 "NON-DR OFF VISTS - MEDICAID AMT 13";
label variable OBOPRV13 "NON-DR OFF VISTS - PRIVATE INS AMT 13";
label variable OBOVA13 "NON-DR OFF VISTS - VA/CHAMPVA AMT 13";
label variable OBOTRI13 "NON-DR OFF VISTS - TRICARE AMT 13";
label variable OBOOFD13 "NON-DR OFF VISTS - OTHER FEDERAL AMT 13";
label variable OBOSTL13 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 13";
label variable OBOWCP13 "NON-DR OFF VISTS - WORKERS COMP AMT 13";
label variable OBOOPR13 "NON-DR OFF VISTS - OTH PRIVATE AMT 13";
label variable OBOOPU13 "NON-DR OFF VISTS - OTH PUBLIC AMT 13";
label variable OBOOSR13 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 13";
label variable OBOPTR13 "NON-DR OFF VISTS - PRV & TRI AMT 13";
label variable OBOOTH13 "NON-DR OFF VISTS - OTH COMBINED AMT 13";
label variable OBCHIR13 "# OFFICE-BASED CHIROPRACTOR VISITS 13";
label variable OBCTCH13 "OFFICE-BASED CHIRO VISIT CHARGES 13";
label variable OBCEXP13 "TOTAL OFF-BASED CHIRO EXP 13";
label variable OBCSLF13 "CHIRO OFF VISITS - SELF/FAMILY AMT 13";
label variable OBCMCR13 "CHIRO OFF VISITS - MEDICARE AMT 13";
label variable OBCMCD13 "CHIRO OFF VISITS - MEDICAID AMT 13";
label variable OBCPRV13 "CHIRO OFF VISITS - PRIVATE INS AMT 13";
label variable OBCVA13 "CHIRO OFF VISITS - VA/CHAMPVA AMT 13";
label variable OBCTRI13 "CHIRO OFF VISITS - TRICARE AMT 13";
label variable OBCOFD13 "CHIRO OFF VISITS - OTHER FEDERAL AMT 13";
label variable OBCSTL13 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 13";
label variable OBCWCP13 "CHIRO OFF VISITS - WORKERS COMP AMT 13";
label variable OBCOPR13 "CHIRO OFF VISTS - OTHR PRIVATE AMT 13";
label variable OBCOPU13 "CHIRO OFF VISTS - OTHR PUBLIC AMT 13";
label variable OBCOSR13 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 13";
label variable OBCPTR13 "CHIRO OFF VISITS - PRV & TRI AMT 13";
label variable OBCOTH13 "CHIRO OFF VISITS -OTH COMBINED AMT 13";
label variable OBNURS13 "# OFF-BASED NURSE/PRACTITIONER VISITS 13";
label variable OBNTCH13 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 13";
label variable OBNEXP13 "TOTAL OFF-BASED NURSE/PRAC 13";
label variable OBNSLF13 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 13";
label variable OBNMCR13 "NURSE/PRAC OFF VISITS - MEDICARE AMT 13";
label variable OBNMCD13 "NURSE/PRAC OFF VSTS - MEDICAID AMT 13";
label variable OBNPRV13 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 13";
label variable OBNVA13 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 13";
label variable OBNTRI13 "NURSE/PRAC OFF VSTS - TRICARE AMT 13";
label variable OBNOFD13 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 13";
label variable OBNSTL13 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 13";
label variable OBNWCP13 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 13";
label variable OBNOPR13 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 13";
label variable OBNOPU13 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 13";
label variable OBNOSR13 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 13";
label variable OBNPTR13 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 13";
label variable OBNOTH13 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 13";
label variable OBOPTO13 "# OFF-BASED OPTOMETRIST VISITS 13";
label variable OBETCH13 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 13";
label variable OBEEXP13 "TOTAL OFF-BASED OPTOMETRIST EXP 13";
label variable OBESLF13 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 13";
label variable OBEMCR13 "OPTOMETRIST OFF VSTS - MEDICARE AMT 13";
label variable OBEMCD13 "OPTOMETRIST OFF VSTS - MEDICAID AMT 13";
label variable OBEPRV13 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 13";
label variable OBEVA13 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 13";
label variable OBETRI13 "OPTOMETRIST OFF VSTS - TRICARE AMT 13";
label variable OBEOFD13 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 13";
label variable OBESTL13 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 13";
label variable OBEWCP13 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 13";
label variable OBEOPR13 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 13";
label variable OBEOPU13 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 13";
label variable OBEOSR13 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 13";
label variable OBEPTR13 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 13";
label variable OBEOTH13 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 13";
label variable OBASST13 "# OFF-BASED PHYSICIAN ASSIST VISITS 13";
label variable OBATCH13 "OFFICE-BASED PHYS ASST VISIT CHARGES 13";
label variable OBAEXP13 "TOTAL OFF-BASED PHYS ASS T EXP 13";
label variable OBASLF13 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 13";
label variable OBAMCR13 "PHYS ASS T OFF VSTS - MEDICARE AMT 13";
label variable OBAMCD13 "PHYS ASS T OFF VSTS - MEDICAID AMT 13";
label variable OBAPRV13 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 13";
label variable OBAVA13 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 13";
label variable OBATRI13 "PHYS ASS T OFF VSTS - TRICARE AMT 13";
label variable OBAOFD13 "PHYS ASS T OFF VSTS - OTHER FED AMT 13";
label variable OBASTL13 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 13";
label variable OBAWCP13 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 13";
label variable OBAOPR13 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 13";
label variable OBAOPU13 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 13";
label variable OBAOSR13 "P A OFF VSTS - OTH UNCLASS SRCE AMT 13";
label variable OBAPTR13 "PHYS ASST OFF VSTS - PRV & TRI AMT 13";
label variable OBAOTH13 "PHYS ASST OFF VSTS - OTH COMBINED AMT 13";
label variable OBTHER13 "# OFF-BASED PT/OT VISITS 13";
label variable OBTTCH13 "OFFICE-BASED PT/OC VISIT CHARGES 13";
label variable OBTEXP13 "TOT OFF-BASED PT EXP 13";
label variable OBTSLF13 "PT/OT OFF VISITS - SELF/FAMILY AMT 13";
label variable OBTMCR13 "PT/OT OFF VISITS - MEDICARE AMT 13";
label variable OBTMCD13 "PT/OT OFF VISITS - MEDICAID AMT 13";
label variable OBTPRV13 "PT/OT OFF VISITS - PRIVATE INS AMT 13";
label variable OBTVA13 "PT/OT OFF VISITS - VA/CHAMPVA AMT 13";
label variable OBTTRI13 "PT/OT OFF VISITS - TRICARE AMT 13";
label variable OBTOFD13 "PT/OT OFF VISITS - OTHER FED AMT 13";
label variable OBTSTL13 "PT/OT OFF VISITS - OTH ST/LOCL AMT 13";
label variable OBTWCP13 "PT/OT OFF VISITS - WORKERS COMP AMT 13";
label variable OBTOPR13 "PT/OT OFF VISITS - OTH PRIVATE AMT 13";
label variable OBTOPU13 "PT/OT OFF VISITS - OTH PUBLIC AMT 13";
label variable OBTOSR13 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 13";
label variable OBTPTR13 "PT/OT OFF VISITS - PRV & TRI AMT 13";
label variable OBTOTH13 "PT/OT OFF VISITS - OTH COMBINED AMT 13";
label variable OPTOTV13 "# OUTPATIENT DEPT PROVIDER VISITS 13";
label variable OPTTCH13 "OPD FACILITY + DR VISIT CHARGES - 13";
label variable OPTEXP13 "TOTAL OUTPATIENT FAC + DR EXP 13";
label variable OPTSLF13 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 13";
label variable OPTMCR13 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 13";
label variable OPTMCD13 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 13";
label variable OPTPRV13 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 13";
label variable OPTVA13 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 13";
label variable OPTTRI13 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 13";
label variable OPTOFD13 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 13";
label variable OPTSTL13 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 13";
label variable OPTWCP13 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 13";
label variable OPTOPR13 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 13";
label variable OPTOPU13 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 13";
label variable OPTOSR13 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 13";
label variable OPTPTR13 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 13";
label variable OPTOTH13 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 13";
label variable OPFTCH13 "OPD PROVIDER VISIT CHARGES - FAC 13";
label variable OPFEXP13 "TOTAL OUTPATIENT FACILITY EXP 13";
label variable OPFSLF13 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 13";
label variable OPFMCR13 "ALL OPD VISITS-MEDICARE AMT-FAC 13";
label variable OPFMCD13 "ALL OPD VISITS-MEDICAID AMT-FAC 13";
label variable OPFPRV13 "ALL OPD VISITS-PRIV INS AMT-FAC 13";
label variable OPFVA13 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 13";
label variable OPFTRI13 "ALL OPD VISITS-TRICARE AMT-FAC 13";
label variable OPFOFD13 "ALL OPD VISITS-OTHER FED AMT-FAC 13";
label variable OPFSTL13 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 13";
label variable OPFWCP13 "ALL OPD VISITS-WORKERS COMP AMT-FAC 13";
label variable OPFOPR13 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 13";
label variable OPFOPU13 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 13";
label variable OPFOSR13 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 13";
label variable OPFPTR13 "ALL OPD VISITS - PRV & TRI AMT-FAC 13";
label variable OPFOTH13 "ALL OPD VISITS - OTH COMBINED AMT-FAC 13";
label variable OPDEXP13 "TOTAL OUTPATIENT PROVIDER EXP 13";
label variable OPDTCH13 "OPD PROVIDER VISIT CHARGES - DR 13";
label variable OPDSLF13 "ALL OPD VISITS-SELF/FAMILY AMT-DR 13";
label variable OPDMCR13 "ALL OPD VISITS-MEDICARE AMT-DR 13";
label variable OPDMCD13 "ALL OPD VISITS-MEDICAID AMT-DR 13";
label variable OPDPRV13 "ALL OPD VISITS-PRIV INS AMT-DR 13";
label variable OPDVA13 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 13";
label variable OPDTRI13 "ALL OPD VISITS-TRICARE AMT-DR 13";
label variable OPDOFD13 "ALL OPD VISITS-OTHER FED AMT-DR 13";
label variable OPDSTL13 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 13";
label variable OPDWCP13 "ALL OPD VISITS-WORKERS COMP AMT-DR 13";
label variable OPDOPR13 "ALL OPD VISITS - OTH PRIVATE AMT-DR 13";
label variable OPDOPU13 "ALL OPD VISITS-OTH PUBLIC AMT-DR 13";
label variable OPDOSR13 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 13";
label variable OPDPTR13 "ALL OPD VISITS-PRV & TRI AMT -DR 13";
label variable OPDOTH13 "ALL OPD VISITS-OTH COMBINED AMT-DR 13";
label variable OPDRV13 "# OUTPATIENT DEPT PHYSICIAN VISITS 13";
label variable OPVTCH13 "OPD PHYSICIAN VISIT CHARGES - FAC 13";
label variable OPVEXP13 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 13";
label variable OPVSLF13 "OPD DR VISITS-SELF/FAMILY AMT-FAC 13";
label variable OPVMCR13 "OPD DR VISITS-MEDICARE AMT-FAC 13";
label variable OPVMCD13 "OPD DR VISITS-MEDICAID AMT-FAC 13";
label variable OPVPRV13 "OPD DR VISITS-PRIV INS AMT-FAC 13";
label variable OPVVA13 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 13";
label variable OPVTRI13 "OPD DR VISITS-TRICARE AMT-FAC 13";
label variable OPVOFD13 "OPD DR VISITS-OTHER FED AMT-FAC 13";
label variable OPVSTL13 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 13";
label variable OPVWCP13 "OPD DR VISITS-WORKERS COMP AMT-FAC 13";
label variable OPVOPR13 "OPD DR VISITS - OTH PRIVATE AMT-FAC 13";
label variable OPVOPU13 "OPD DR VISITS-OTH PUBLIC AMT-FAC 13";
label variable OPVOSR13 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 13";
label variable OPVPTR13 "OPD DR VISITS - PRV & TRI AMT-FAC 13";
label variable OPVOTH13 "OPD DR VISITS - OTH COMBINED AMT-FAC 13";
label variable OPSEXP13 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 13";
label variable OPSTCH13 "OPD PHYSICIAN VISIT CHARGES - DR 13";
label variable OPSSLF13 "OPD DR VISITS-SELF/FAMILY AMT-DR 13";
label variable OPSMCR13 "OPD DR VISITS-MEDICARE AMT-DR 13";
label variable OPSMCD13 "OPD DR VISITS-MEDICAID AMT-DR 13";
label variable OPSPRV13 "OPD DR VISITS-PRIV INS AMT-DR 13";
label variable OPSVA13 "OPD DR VISITS-VA/CHAMPVA AMT-DR 13";
label variable OPSTRI13 "OPD DR VISITS-TRICARE AMT-DR 13";
label variable OPSOFD13 "OPD DR VISITS-OTHER FED AMT-DR 13";
label variable OPSSTL13 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 13";
label variable OPSWCP13 "OPD DR VISITS-WORKERS COMP AMT-DR 13";
label variable OPSOPR13 "OPD DR VISITS - OTH PRIVATE AMT-DR 13";
label variable OPSOPU13 "OPD DR VISITS-OTH PUBLIC AMT-DR 13";
label variable OPSOSR13 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 13";
label variable OPSPTR13 "OPD DR VISITS - PRV & TRI AMT-DR 13";
label variable OPSOTH13 "OPD DR VISITS -OTH COMBINED AMT-DR 13";
label variable OPOTHV13 "# OUTPATIENT DEPT NON-DR VISITS 13";
label variable OPOTCH13 "OPD NON-PHYS VISIT CHARGES - FAC 13";
label variable OPOEXP13 "TOTAL OUTPATIENT NON-DR - FAC EXP 13";
label variable OPOSLF13 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 13";
label variable OPOMCR13 "OPD NON-DR VISITS-MEDICARE AMT-FAC 13";
label variable OPOMCD13 "OPD NON-DR VISITS-MEDICAID AMT-FAC 13";
label variable OPOPRV13 "OPD NON-DR VISITS-PRIV INS AMT-FAC 13";
label variable OPOVA13 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 13";
label variable OPOTRI13 "OPD NON-DR VISITS-TRICARE AMT-FAC 13";
label variable OPOOFD13 "OPD NON-DR VISITS-OTHER FED AMT-FAC 13";
label variable OPOSTL13 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 13";
label variable OPOWCP13 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 13";
label variable OPOOPR13 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 13";
label variable OPOOPU13 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 13";
label variable OPOOSR13 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 13";
label variable OPOPTR13 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 13";
label variable OPOOTH13 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 13";
label variable OPPEXP13 "TOTAL OUTPATIENT NON-DR - DR EXP 13";
label variable OPPTCH13 "OPD NON-PHYS VISIT CHARGES - DR 13";
label variable OPPSLF13 "OPD NON-DR VISITS-SELF/FAM AMT-DR 13";
label variable OPPMCR13 "OPD NON-DR VISITS-MEDICARE AMT-DR 13";
label variable OPPMCD13 "OPD NON-DR VISITS-MEDICAID AMT-DR 13";
label variable OPPPRV13 "OPD NON-DR VISITS-PRIV INS AMT-DR 13";
label variable OPPVA13 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 13";
label variable OPPTRI13 "OPD NON-DR VISITS-TRICARE AMT-DR 13";
label variable OPPOFD13 "OPD NON-DR VISITS-OTHER FED AMT-DR 13";
label variable OPPSTL13 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 13";
label variable OPPWCP13 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 13";
label variable OPPOPR13 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 13";
label variable OPPOPU13 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 13";
label variable OPPOSR13 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 13";
label variable OPPPTR13 "OPD NON-DR VISITS - PRV & TRI AMT-DR 13";
label variable OPPOTH13 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 13";
label variable AMCHIR13 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2013";
label variable AMCTCH13 "CHIRO AMBULATORY VISIT CHARGES 13";
label variable AMCEXP13 "TOTL AMBULTRY (OB+OP) CHIRO EXP 13";
label variable AMCSLF13 "CHIRO AMB VISITS - SELF/FAMILY AMT 13";
label variable AMCMCR13 "CHIRO AMB VISITS - MEDICARE AMT 13";
label variable AMCMCD13 "CHIRO AMB VISITS - MEDICAID AMT 13";
label variable AMCPRV13 "CHIRO AMB VISITS - PRIVATE INS AMT 13";
label variable AMCVA13 "CHIRO AMB VISITS - VA/CHAMPVA AMT 13";
label variable AMCTRI13 "CHIRO AMB VISITS-TRICARE AMT 13";
label variable AMCOFD13 "CHIRO AMB VISITS - OTHER FEDERAL AMT 13";
label variable AMCSTL13 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 13";
label variable AMCWCP13 "CHIRO AMB VISITS-WORKERS COMP AMT 13";
label variable AMCOPR13 "CHIRO AMB VISITS - OTH PRIVATE AMT 13";
label variable AMCOPU13 "CHIRO AMB VISITS - OTH PUBLIC AMT 13";
label variable AMCOSR13 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 13";
label variable AMCPTR13 "CHIRO AMB VISITS -PRV & TRI AMT 13";
label variable AMCOTH13 "CHIRO AMB VISITS - OTH COMBINED AMT 13";
label variable AMNURS13 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 13";
label variable AMNTCH13 "NRS/PRAC AMBULATORY VISIT CHARGES 13";
label variable AMNEXP13 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 13";
label variable AMNSLF13 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 13";
label variable AMNMCR13 "NRS/PRAC AMB VSTS - MEDICARE AMT 13";
label variable AMNMCD13 "NRS/PRAC AMB VSTS - MEDICAID AMT 13";
label variable AMNPRV13 "NRS/PRAC AMB VSTS - PRIV INS AMT 13";
label variable AMNVA13 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 13";
label variable AMNTRI13 "NRS/PRAC AMB VSTS-TRICARE AMT 13";
label variable AMNOFD13 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 13";
label variable AMNSTL13 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 13";
label variable AMNWCP13 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 13";
label variable AMNOPR13 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 13";
label variable AMNOPU13 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 13";
label variable AMNOSR13 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 13";
label variable AMNPTR13 "NRS/PRAC AMB VSTS - PRV & TRI AMT 13";
label variable AMNOTH13 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 13";
label variable AMOPTO13 "# AMB OPTOMETRIST VSTS (OB+OP) 13";
label variable AMETCH13 "OPTOMETRIST AMBULATORY VISIT CHARGES 13";
label variable AMEEXP13 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 13";
label variable AMESLF13 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 13";
label variable AMEMCR13 "OPTMTRIST AMB VSTS - MEDICARE AMT 13";
label variable AMEMCD13 "OPTMTRIST AMB VSTS - MEDICAID AMT 13";
label variable AMEPRV13 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 13";
label variable AMEVA13 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 13";
label variable AMETRI13 "OPTMTRIST AMB VSTS-TRICARE AMT 13";
label variable AMEOFD13 "OPTMTRIST AMB VSTS-OTHER FED AMT 13";
label variable AMESTL13 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 13";
label variable AMEWCP13 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 13";
label variable AMEOPR13 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 13";
label variable AMEOPU13 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 13";
label variable AMEOSR13 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 13";
label variable AMEPTR13 "OPTMTRIST AMB VSTS - PRV & TRI AMT 13";
label variable AMEOTH13 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 13";
label variable AMASST13 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2013";
label variable AMATCH13 "PHYS ASS T AMBULATORY VISIT CHARGES 13";
label variable AMAEXP13 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 13";
label variable AMASLF13 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 13";
label variable AMAMCR13 "PHYS ASS T AMB VSTS-MEDICARE AMT 13";
label variable AMAMCD13 "PHYS ASS T AMB VSTS-MEDICAID AMT 13";
label variable AMAPRV13 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 13";
label variable AMAVA13 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 13";
label variable AMATRI13 "PHYS ASS T AMB VSTS-TRICARE AMT 13";
label variable AMAOFD13 "PHYS ASS T AMB VSTS - OTHER FED AMT 13";
label variable AMASTL13 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 13";
label variable AMAWCP13 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 13";
label variable AMAOPR13 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 13";
label variable AMAOPU13 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 13";
label variable AMAOSR13 "P A AMB VSTS - OTH UNCLASS SRCE AMT 13";
label variable AMAPTR13 "PHYS ASS T AMB VSTS - PRV & TRI AMT 13";
label variable AMAOTH13 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 13";
label variable AMTHER13 "# AMB PT/OT THRPY VISITS (OB+OP) 13";
label variable AMTTCH13 "PT/OC AMBULATORY VISIT CHARGES 13";
label variable AMTEXP13 "TOTL AMBULTRY (OB+OP) PT/OT EXP 13";
label variable AMTSLF13 "PT/OT AMB VISITS-SELF/FAMILY AMT 13";
label variable AMTMCR13 "PT/OT AMB VISITS-MEDICARE AMT 13";
label variable AMTMCD13 "PT/OT AMB VISITS-MEDICAID AMT 13";
label variable AMTPRV13 "PT/OT AMB VISITS-PRIVATE INS AMT 13";
label variable AMTVA13 "PT/OT AMB VISITS-VA/CHAMPVA AMT 13";
label variable AMTTRI13 "PT/OT AMB VISITS-TRICARE AMT 13";
label variable AMTOFD13 "PT/OT AMB VISITS - OTHER FED AMT 13";
label variable AMTSTL13 "PT/OT AMB VISITS-OTH ST/LOCL AMT 13";
label variable AMTWCP13 "PT/OT AMB VISITS-WORKERS COMP AMT 13";
label variable AMTOPR13 "PT/OT AMB VISITS - OTH PRIVATE AMT 13";
label variable AMTOPU13 "PT/OT AMB VISITS-OTH PUBLIC AMT 13";
label variable AMTOSR13 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 13";
label variable AMTPTR13 "PT/OT AMB VISITS -PRV & TRI AMT 13";
label variable AMTOTH13 "PT/OT AMB VISITS - OTH COMBINED AMT 13";
label variable AMTOTC13 "# CALLS W/OFFICE & OUPAT DEPTS, 2013";
label variable AMDRC13 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2013";
label variable ERTOT13 "# EMERGENCY ROOM VISITS 13";
label variable ERTTCH13 "ER FACILITY + DR VISIT CHARGES 13";
label variable ERTEXP13 "TOTAL ER FACILITY + DR EXP 13";
label variable ERTSLF13 "ER-SELF/FAMILY AMT-(FAC+DR) 13";
label variable ERTMCR13 "ER-MEDICARE AMT-(FAC+DR) 13";
label variable ERTMCD13 "ER-MEDICAID AMT-(FAC+DR) 13";
label variable ERTPRV13 "ER-PRIV INS AMT-(FAC+DR) 13";
label variable ERTVA13 "ER-VA/CHAMPVA AMT-(FAC+DR) 13";
label variable ERTTRI13 "ER-TRICARE AMT-(FAC+DR) 13";
label variable ERTOFD13 "ER-OTHER FED AMT-(FAC+DR) 13";
label variable ERTSTL13 "ER-OTH ST/LOCAL AMT-(FAC+DR) 13";
label variable ERTWCP13 "ER-WORKERS COMP AMT-(FAC+DR) 13";
label variable ERTOPR13 "ER-OTH PRIVATE AMT-(FAC+DR) 13";
label variable ERTOPU13 "ER-OTH PUBLIC AMT-(FAC+DR) 13";
label variable ERTOSR13 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 13";
label variable ERTPTR13 "ER-PRV & TRI AMT (FAC+DR) 13";
label variable ERTOTH13 "ER -OTH COMBINED AMT (FAC+DR) 13";
label variable ERFTCH13 "ER FACILITY VISIT CHARGES 13";
label variable ERFEXP13 "TOTAL ER FACILITY EXP 13";
label variable ERFSLF13 "ER-SELF/FAMILY AMT - FAC 13";
label variable ERFMCR13 "ER-MEDICARE AMT - FAC 13";
label variable ERFMCD13 "ER-MEDICAID AMT - FAC 13";
label variable ERFPRV13 "ER-PRIVATE INS AMT - FAC 13";
label variable ERFVA13 "ER-VA/CHAMPVA AMT - FAC 13";
label variable ERFTRI13 "ER-TRICARE AMT - FAC 13";
label variable ERFOFD13 "ER-OTHER FEDERAL AMT - FAC 13";
label variable ERFSTL13 "ER-OTH ST/LOCAL AMT - FAC 13";
label variable ERFWCP13 "ER-WORKERS COMP AMT - FAC 13";
label variable ERFOPR13 "ER-OTHER PRIVATE AMT - FAC 13";
label variable ERFOPU13 "ER-OTHER PUBLIC AMT - FAC 13";
label variable ERFOSR13 "ER-OTH UNCLASS SRCE AMT - FAC 13";
label variable ERFPTR13 "ER-PRV & TRI AMT - FAC 13";
label variable ERFOTH13 "ER-OTH COMBINED AMT - FAC 13";
label variable ERDEXP13 "TOTAL EMERGENCY ROOM DR EXP 13";
label variable ERDTCH13 "ER DOCTOR VISIT CHARGES 13";
label variable ERDSLF13 "ER-SELF/FAMILY AMT - DR 13";
label variable ERDMCR13 "ER-MEDICARE AMT - DR 13";
label variable ERDMCD13 "ER-MEDICAID AMT - DR 13";
label variable ERDPRV13 "ER-PRIVATE INS AMT - DR 13";
label variable ERDVA13 "ER-VA/CHAMPVA AMT - DR 13";
label variable ERDTRI13 "ER-TRICARE AMT - DR 13";
label variable ERDOFD13 "ER-OTHER FED AMT - DR 13";
label variable ERDSTL13 "ER-OTH ST/LOCAL AMT - DR 13";
label variable ERDWCP13 "ER-WORKERS COMP AMT - DR 13";
label variable ERDOPR13 "ER - OTHER PRIVATE AMT - DR 13";
label variable ERDOPU13 "ER - OTHER PUBLIC AMT - DR 13";
label variable ERDOSR13 "ER-OTH UNCLASS SRCE AMT - DR 13";
label variable ERDPTR13 "ER-PRV & TRI AMT - DR 13";
label variable ERDOTH13 "ER-OTH COMBINED AMT - DR 13";
label variable IPZERO13 "# ZERO-NIGHT HOSPITAL STAYS 13";
label variable ZIFTCH13 "ZERO-NITE IP STAY CHARGES - FAC 13";
label variable ZIFEXP13 "TOTAL ZERO-NITE STAYS FAC EXP 13";
label variable ZIFSLF13 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 13";
label variable ZIFMCR13 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 13";
label variable ZIFMCD13 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 13";
label variable ZIFPRV13 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 13";
label variable ZIFVA13 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 13";
label variable ZIFTRI13 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 13";
label variable ZIFOFD13 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 13";
label variable ZIFSTL13 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 13";
label variable ZIFWCP13 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 13";
label variable ZIFOPR13 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 13";
label variable ZIFOPU13 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 13";
label variable ZIFOSR13 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 13";
label variable ZIFPTR13 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 13";
label variable ZIFOTH13 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 13";
label variable ZIDEXP13 "TOTAL ZERO-NITE STAZ DR 13";
label variable ZIDTCH13 "ZERO-NITE IP STAY CHARGES - DR 13";
label variable ZIDSLF13 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 13";
label variable ZIDMCR13 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 13";
label variable ZIDMCD13 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 13";
label variable ZIDPRV13 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 13";
label variable ZIDVA13 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 13";
label variable ZIDTRI13 "ZERO-NITE IP STAZ-TRICARE AMT-DR 13";
label variable ZIDOFD13 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 13";
label variable ZIDSTL13 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 13";
label variable ZIDWCP13 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 13";
label variable ZIDOPR13 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 13";
label variable ZIDOPU13 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 13";
label variable ZIDOSR13 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 13";
label variable ZIDPTR13 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 13";
label variable ZIDOTH13 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 13";
label variable IPDIS13 "# HOSPITAL DISCHARGES, 2013";
label variable IPTEXP13 "TOT HOSP IP FACILITY + DR EXP 13";
label variable IPTTCH13 "IP HOSP STAY CHARGES (FAC+DR) 13";
label variable IPTSLF13 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 13";
label variable IPTMCR13 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 13";
label variable IPTMCD13 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 13";
label variable IPTPRV13 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 13";
label variable IPTVA13 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 13";
label variable IPTTRI13 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 13";
label variable IPTOFD13 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 13";
label variable IPTSTL13 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 13";
label variable IPTWCP13 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 13";
label variable IPTOPR13 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 13";
label variable IPTOPU13 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 13";
label variable IPTOSR13 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 13";
label variable IPTPTR13 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 13";
label variable IPTOTH13 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 13";
label variable IPFEXP13 "TOT HOSP IP FACILITY EXP-INC 0 NITES 13";
label variable IPFTCH13 "IP HOSP STAY CHARGES - FAC 13";
label variable IPFSLF13 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 13";
label variable IPFMCR13 "IP HOSP STAZ-MEDICARE AMT-FAC 13";
label variable IPFMCD13 "IP HOSP STAZ-MEDICAID AMT-FAC 13";
label variable IPFPRV13 "IP HOSP STAZ-PRIV INS AMT-FAC 13";
label variable IPFVA13 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 13";
label variable IPFTRI13 "IP HOSP STAZ-TRICARE AMT-FAC 13";
label variable IPFOFD13 "IP HOSP STAZ-OTHER FED AMT-FAC 13";
label variable IPFSTL13 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 13";
label variable IPFWCP13 "IP HOSP STAZ-WORKERS COMP AMT-FAC 13";
label variable IPFOPR13 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 13";
label variable IPFOPU13 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 13";
label variable IPFOSR13 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 13";
label variable IPFPTR13 "IP HOSP STAZ-PRV & TRI AMT-FAC 13";
label variable IPFOTH13 "IP HOSP STAZ-OTH COMBINED AMT-FAC 13";
label variable IPDEXP13 "TOTL HOSP STAZ DR EXP 13";
label variable IPDTCH13 "IP HOSP STAY CHARGES - DR 13";
label variable IPDSLF13 "IP HOSP STAZ-SELF/FAMILY AMT-DR 13";
label variable IPDMCR13 "IP HOSP STAZ-MEDICARE AMT- DR 13";
label variable IPDMCD13 "IP HOSP STAZ-MEDICAID AMT-DR 13";
label variable IPDPRV13 "IP HOSP STAZ-PRIV INS AMT-DR 13";
label variable IPDVA13 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 13";
label variable IPDTRI13 "IP HOSP STAZ-TRICARE AMT-DR 13";
label variable IPDOFD13 "IP HOSP STAZ-OTHER FED AMT-DR 13";
label variable IPDSTL13 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 13";
label variable IPDWCP13 "IP HOSP STAZ-WORKERS COMP AMT-DR 13";
label variable IPDOPR13 "IP HOSP STAZ - OTH PRIVATE AMT-DR 13";
label variable IPDOPU13 "IP HOSP STAZ - OTH PUBLIC AMT-DR 13";
label variable IPDOSR13 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 13";
label variable IPDPTR13 "IP HOSP STAZ-PRV & TRI AMT-DR 13";
label variable IPDOTH13 "IP HOSP STAZ-OTH COMBINED AMT-DR 13";
label variable IPNGTD13 "# NIGHTS IN HOSP FOR DISCHARGES, 2013";
label variable DVTOT13 "# DENTAL CARE VISITS 13";
label variable DVTTCH13 "TOTAL DENTAL CARE VISIT CHARGES 13";
label variable DVTEXP13 "TOTAL DENTAL CARE EXP 13";
label variable DVTSLF13 "ALL DENTAL CARE - SELF/FAMILY AMT 13";
label variable DVTMCR13 "ALL DENTAL CARE - MEDICARE AMT 13";
label variable DVTMCD13 "ALL DENTAL CARE - MEDICAID AMT 13";
label variable DVTPRV13 "ALL DENTAL CARE - PRIVATE INS AMT 13";
label variable DVTVA13 "ALL DENTAL CARE - VA/CHAMPVA AMT 13";
label variable DVTTRI13 "ALL DENTAL CARE - TRICARE AMT 13";
label variable DVTOFD13 "ALL DENTAL CARE - OTHER FEDRL AMT 13";
label variable DVTSTL13 "ALL DENTAL CARE - OTH ST/LOCAL AMT 13";
label variable DVTWCP13 "ALL DENTAL CARE - WORKERS COMP AMT 13";
label variable DVTOPR13 "ALL DENTAL CARE - OTH PRIVATE AMT 13";
label variable DVTOPU13 "ALL DENTAL CARE - OTH PUBLIC AMT 13";
label variable DVTOSR13 "ALL DENT CARE-OT UNCLASS SRCE AMT 13";
label variable DVTPTR13 "ALL DENTAL CARE - PRV & TRI AMT 13";
label variable DVTOTH13 "ALL DENTAL CARE - OTH COMBINED AMT 13";
label variable DVGEN13 "# GENERAL DENTIST VISITS 13";
label variable DVGTCH13 "GENERAL DENTAL CARE VISIT CHARGES 13";
label variable DVGEXP13 "TOTAL GENERAL DENTIST EXP 13";
label variable DVGSLF13 "GNRL DENTAL VISITS - SELF/FAM AMT 13";
label variable DVGMCR13 "GNRL DENTAL VISITS - MEDICARE AMT 13";
label variable DVGMCD13 "GNRL DENTAL VISITS - MEDICAID AMT 13";
label variable DVGPRV13 "GNRL DENTAL VISITS - PRIVATE INS AMT 13";
label variable DVGVA13 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 13";
label variable DVGTRI13 "GNRL DENTAL VISITS-TRICARE AMT 13";
label variable DVGOFD13 "GNRL DENTAL VISITS - OTHER FED AMT 13";
label variable DVGSTL13 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 13";
label variable DVGWCP13 "GNRL DENTAL VISITS - WORKERS COMP AMT 13";
label variable DVGOPR13 "GNRL DENTAL VISITS - OTH PRIVATE AMT 13";
label variable DVGOPU13 "GNRL DENTAL VISITS - OTH PUBLIC AMT 13";
label variable DVGOSR13 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 13";
label variable DVGPTR13 "GNRL DENTAL VISITS - PRV & TRI AMT 13";
label variable DVGOTH13 "GNRL DENTAL VISITS - OTH COMBINED AMT 13";
label variable DVORTH13 "# ORTHODONTIST VISITS 13";
label variable DVOTCH13 "ORTHODONTIST VISIT CHARGES 13";
label variable DVOEXP13 "TOTAL ORTHODONTIST EXP 13";
label variable DVOSLF13 "ORTHODONTIST VISITS - SELF/FAMILY AMT 13";
label variable DVOMCR13 "ORTHODONTIST VISITS - MEDICARE AMT 13";
label variable DVOMCD13 "ORTHODONTIST VISITS - MEDICAID AMT 13";
label variable DVOPRV13 "ORTHODONTIST VISITS - PRIVATE INS AMT 13";
label variable DVOVA13 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 13";
label variable DVOTRI13 "ORTHODONTIST VISITS-TRICARE AMT 13";
label variable DVOOFD13 "ORTHODONTIST VISITS-OTHR FED AMT 13";
label variable DVOSTL13 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 13";
label variable DVOWCP13 "ORTHODONTIST VISITS-WORKERS COMP AMT 13";
label variable DVOOPR13 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 13";
label variable DVOOPU13 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 13";
label variable DVOOSR13 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 13";
label variable DVOPTR13 "ORTHODONTIST VISITS - PRV & TRI AMT 13";
label variable DVOOTH13 "ORTHODONTIST VISITS-OTH COMBINED AMT 13";
label variable HHTOTD13 "# HOME HEALTH PROVIDER DAYS, 2013";
label variable HHAGD13 "# AGENCY HOME HEALTH PROVIDER DAYS 13";
label variable HHATCH13 "HOME HEALTH AGENCY VISIT CHARGES 13";
label variable HHAEXP13 "TOTAL HOME HEALTH AGENCY EXP 13";
label variable HHASLF13 "HOME HLTH AGENCY - SELF/FAMILY AMT 13";
label variable HHAMCR13 "HOME HLTH AGENCY - MEDICARE AMT 13";
label variable HHAMCD13 "HOME HLTH AGENCY - MEDICAID AMT 13";
label variable HHAPRV13 "HOME HLTH AGENCY - PRIVATE INS AMT 13";
label variable HHAVA13 "HOME HLTH AGENCY-VA/CHAMPVA AMT 13";
label variable HHATRI13 "HOME HLTH AGENCY-TRICARE AMT 13";
label variable HHAOFD13 "HOME HLTH AGENCY - OTHER FED AMT 13";
label variable HHASTL13 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 13";
label variable HHAWCP13 "HOME HLTH AGENCY - WORKERS COMP AMT 13";
label variable HHAOPR13 "HOME HLTH AGENCY - OTH PRIVATE AMT 13";
label variable HHAOPU13 "HOME HLTH AGENCY - OTH PUBLIC AMT 13";
label variable HHAOSR13 "H HLTH AGENCY - OT UNCLASS SRCE AMT 13";
label variable HHAPTR13 "HOME HLTH AGENCY - PRV & TRI AMT 13";
label variable HHAOTH13 "HOME HLTH AGENCY - OTH COMBINED AMT 13";
label variable HHINDD13 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 13";
label variable HHNTCH13 "HOME HEALTH NON-AGENCY VISIT CHARGES 13";
label variable HHNEXP13 "TOTAL HOME HEALTH NON-AGNCY EXP 13";
label variable HHNSLF13 "HOME HLTH NON-AGNCY - SELF/FAM AMT 13";
label variable HHNMCD13 "HOME HLTH NON-AGNCY - MEDICAID AMT 13";
label variable HHNMCR13 "HOME HLTH NON-AGNCY - MEDICARE AMT 13";
label variable HHNPRV13 "HOME HLTH NON-AGNCY - PRIV INS AMT 13";
label variable HHNVA13 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 13";
label variable HHNTRI13 "HOME HLTH NON-AGNCY-TRICARE AMT 13";
label variable HHNOFD13 "HOME HLTH NON-AGNCY-OTHR FED AMT 13";
label variable HHNSTL13 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 13";
label variable HHNWCP13 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 13";
label variable HHNOPR13 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 13";
label variable HHNOPU13 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 13";
label variable HHNOSR13 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 13";
label variable HHNPTR13 "HOME HLTH NON-AGNCY - PRV & TRI AMT 13";
label variable HHNOTH13 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 13";
label variable HHINFD13 "# INFORMAL HOME HEALTH PROVIDER DAYS 13";
label variable VISEXP13 "TOTAL GLASSES/CONTACT LENS EXP 13";
label variable VISTCH13 "GLASSES/CONTACT LENSES CHARGES 13";
label variable VISSLF13 "GLASSES/CNTCT LENSES -SELF/FAM AMT 13";
label variable VISMCR13 "GLASSES/CNTCT LENSES-MEDICARE AMT 13";
label variable VISMCD13 "GLASSES/CNTCT LENSES-MEDICAID AMT 13";
label variable VISPRV13 "GLASSES/CNTCT LENSES-PRIV INS AMT 13";
label variable VISVA13 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 13";
label variable VISTRI13 "GLASSES/LENSES-TRICARE AMT 13";
label variable VISOFD13 "GLASSES/CNTCT LENSES-OTHR FED AMT 13";
label variable VISSTL13 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 13";
label variable VISWCP13 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 13";
label variable VISOPR13 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 13";
label variable VISOPU13 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 13";
label variable VISOSR13 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 13";
label variable VISPTR13 "GLASSES/CNTCT LENSES-PRV & TRI AMT 13";
label variable VISOTH13 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 13";
label variable OTHTCH13 "OTHER EQUP/SUPPLIES CHARGES 13";
label variable OTHEXP13 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 13";
label variable OTHSLF13 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 13";
label variable OTHMCR13 "OTHER EQUP/SUPPLIES-MEDICARE AMT 13";
label variable OTHMCD13 "OTHER EQUP/SUPPLIES-MEDICAID AMT 13";
label variable OTHPRV13 "OTHER EQUP/SUPPLIES-PRIV INS AMT 13";
label variable OTHVA13 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 13";
label variable OTHTRI13 "OTHER EQUP/SUPPLY-TRICARE AMT 13";
label variable OTHOFD13 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 13";
label variable OTHSTL13 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 13";
label variable OTHWCP13 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 13";
label variable OTHOPR13 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 13";
label variable OTHOPU13 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 13";
label variable OTHOSR13 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 13";
label variable OTHPTR13 "OTHER EQUP/SUPPLY - PRV & TRI AMT 13";
label variable OTHOTH13 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 13";
label variable RXTOT13 "# PRESC MEDS INCL REFILLS 13";
label variable RXEXP13 "TOTAL RX-EXP 13";
label variable RXSLF13 "TOTAL RX-SELF/FAMILY AMT 13";
label variable RXMCR13 "TOTAL RX-MEDICARE AMT 13";
label variable RXMCD13 "TOTAL RX-MEDICAID AMT 13";
label variable RXPRV13 "TOTAL RX-PRIVATE INS AMT 13";
label variable RXVA13 "TOTAL RX-VA/CHAMPVA AMT 13";
label variable RXTRI13 "TOTAL RX-TRICARE AMT 13";
label variable RXOFD13 "TOTAL RX-OTHER FED AMT 13";
label variable RXSTL13 "TOTAL RX-OTHER ST/LOCAL AMT 13";
label variable RXWCP13 "TOTAL RX-WORKERS COMP AMT 13";
label variable RXOPR13 "TOTAL RX-OTH PRIVATE AMT 13";
label variable RXOPU13 "TOTAL RX-OTH PUBLIC AMT 13";
label variable RXOSR13 "TOT RX-OTH UNCLASS SRCE AMT 13";
label variable RXPTR13 "TOTAL RX-PRV & TRI AMT 13";
label variable RXOTH13 "TOTAL RX-OTH COMBINED AMT 13";
label variable PERWT13F "FINAL PERSON WEIGHT, 2013";
label variable FAMWT13F "FINAL FAMILY WEIGHT, 2013";
label variable FAMWT13C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/13";
label variable SAQWT13F "FINAL SAQ PERSON WEIGHT, 2013";
label variable DIABW13F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2013";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2013";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1630001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1630002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1630003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1630004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1630005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1630008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1630010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1630013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1630015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1630027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1630031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1630032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1630034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630035X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1630036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1630045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1630046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1630047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1630050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1630054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1630059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1630063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1630064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1630065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630067X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630068X
         0 "0.00"
         116 "$1 - $116" ;

label define H1630069X
         0 "0.00"
         503 "$1 - $503" ;

label define H1630070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630072X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1630076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1630091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1630092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1630093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR"
         2013 "2013 YEAR" ;

label define H1630097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR" ;

label define H1630098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR"
         2014 "2014 YEAR" ;

label define H1630099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630103X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630105X
         -1 "-1 INAPPLICABLE, ALL PANEL 17, DEC/INSTD"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1630110X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1630111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1630112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1630113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1630114X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630122X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630125X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1630130X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630132X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630141X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1630142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1630143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1630144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630149X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630153X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1630175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1630176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1630177X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1630178X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1630179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1630182X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1630193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1630195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1630199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1630205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630208X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1630210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1630211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1630212X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1630213X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1630214X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1630215X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630216X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630228X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1630229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1630230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1630231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1630240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630252X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630264X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630265X
         0 "0.00"
         380 "$1 - $380" ;

label define H1630266X
         0 "0.00"
         173 "$1 - $173" ;

label define H1630267X
         0 "0.00"
         50 "$1 - $50" ;

label define H1630268X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630269X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630271X
         -1 "-1 INAPPLICABLE OR UNDER 5"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         13 "13 GED OR HS GRAD"
         14 "14 BEYOND HS,COLLEGE(NO 4YR DEG),ASSOC DEG"
         15 "15 4-YEAR COLLEGE DEGREE, BACHELOR'S DEGREE"
         16 "16 MASTER'S, DOCTORATE, OR PROFESSIONAL DEG"
         2 "2 9 - 12TH GRADE, NO HS DIPLOMA OR GED" ;

label define H1630272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         10 "10 CHILD UNDER 5 YEARS OLD"
         2 "2 9-12TH GRADE, NO HIGH SCHOOL DIPLOMA"
         3 "3 GED OR EQUIVALENT"
         4 "4 HIGH SCHOOL DIPLOMA"
         5 "5 SOME COLLEGE, NO DEGREE"
         6 "6 ASSOC DEG: OCCUPATIONAL,TECH,VOCATIONAL"
         7 "7 ASSOCIATE DEGREE: ACADEMIC PROGRAM"
         8 "8 BACHELOR'S DEGREE (BA,AB,BS,BBA)"
         9 "9 MASTER'S, PROFESSIONAL, DOCTORAL DEGREE" ;

label define H1630273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1630274X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1630275X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1630276X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1630277X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1630278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1630281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1630282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1630283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1630287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR"
         2013 "2013 YEAR" ;

label define H1630288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR"
         2013 "2013 YEAR" ;

label define H1630289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR" ;

label define H1630290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2013 "2013 YEAR"
         2014 "2014 YEAR" ;

label define H1630291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630292X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630293X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630298X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1630299X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1630300X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1630301X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1630302X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1630303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1630305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1630306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630307X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1630308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1630313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1630316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1630317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1630318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1630319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1630320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS"
         5 "5 SOME OTHER WAY" ;

label define H1630321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630324X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630333X
         0 "0.00"
         716 "$1 - $716" ;

label define H1630334X
         0 "0.00"
         335 "$1 - $335" ;

label define H1630335X
         0 "0.00"
         70 "$1 - $70" ;

label define H1630336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630339X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1630340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1630341X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H1630342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1630343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1630345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1630346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1630347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630348X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630349X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630422X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1630423X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1630424X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1630425X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $76.96"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630426X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $76.96"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630427X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $76.96"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630428X
         0 "0 NO"
         1 "1 YES" ;

label define H1630429X
         0 "0 NO"
         1 "1 YES" ;

label define H1630430X
         0 "0 NO"
         1 "1 YES" ;

label define H1630431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 IN ROUND 1 AND OTHLANG=1, INAPP" ;

label define H1630435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630439X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1630440X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1630441X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1630442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630452X
         1 "1 IN-SCOPE ON 12/31/2013"
         2 "2 NOT IN-SCOPE ON 12/31/2013" ;

label define H1630453X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/13"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1630454X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/13"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1630455X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/13"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1630456X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/13"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1630457X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2013"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2013" ;

label define H1630458X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1630459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630470X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630472X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H1630473X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630474X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1630475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630476X
         0 "0.00"
         20 "$1 - $20" ;

label define H1630477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630478X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630479X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1630481X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1630482X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1630483X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630487X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630488X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1630489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630490X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1630492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630493X
         -1 "-1 INAPPLICABLE, ALL P17, JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H1630494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1630496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1630497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

label define H1630498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1630499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1630500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1630503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1630504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1630505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1630506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630532X
         1 "1 YES"
         2 "2 NO" ;

label define H1630533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630535X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630536X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630537X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630546X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630547X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630548X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1630549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630563X
         1 "1 YES"
         2 "2 NO" ;

label define H1630564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630580X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630581X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630582X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630583X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630584X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630585X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630586X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630587X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630588X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630589X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630590X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630591X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1630592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630594X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630596X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630598X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630599X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1630601X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1630603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630604X
         -1 "-1 INAPPLICALBE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630605X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630606X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630610X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630611X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630614X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630615X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630617X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1630618X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1630619X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1630620X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630621X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630622X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630623X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1630624X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630625X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630626X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$76.96"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630627X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$76.96"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630628X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$76.96"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630629X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630630X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630631X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630632X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630633X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630634X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630635X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1630636X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630637X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630639X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630640X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630641X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1630643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1630644X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1630645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630646X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630647X
         0 "0.00"
         116 "$1 - $116" ;

label define H1630648X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630651X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630654X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1630655X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1630656X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1630657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630667X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630671X
         1 "1 YES"
         2 "2 NO" ;

label define H1630672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630684X
         1 "1 YES"
         2 "2 NO" ;

label define H1630685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630697X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630698X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630699X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630700X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630701X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630702X
         -1 "-1 INAPPLICABLE, ALL P17, JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630703X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630704X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630705X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630706X
         0 "0.00"
         944 "$1 - $944" ;

label define H1630707X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630708X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630725X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630726X
         17 "17 PANEL 17"
         18 "18 PANEL 18" ;

label define H1630727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630729X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630730X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630732X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630733X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630758X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630759X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630760X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1630761X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1630762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1630763X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1630764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630766X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1630767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630769X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1630777X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1630778X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1630779X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1630780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630782X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630783X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1630784X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1630785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1630787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1630788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630791X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630792X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630793X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630822X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630824X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1630825X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1630826X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1630827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630829X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630830X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630831X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630835X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630836X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630837X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630838X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630839X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630876X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1630877X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1630878X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1630879X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1630880X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1630881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630893X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630894X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630895X
         1 "1 YES"
         2 "2 NO" ;

label define H1630896X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630897X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630898X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630899X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630900X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1630901X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630902X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1630903X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1630904X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1630905X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1630906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630908X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630918X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1630927X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1630928X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1630929X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H1630930X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1630931X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H1630932X
         -1 "-1 INAPPLICABLE"
         1 "1 OLD RACE QUESTIONS"
         2 "2 NEW RACE QUESTIONS" ;

label define H1630933X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1630934X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630935X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1630936X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630937X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1630938X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1630939X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1630940X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1630941X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1630942X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1630943X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1630944X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1630945X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1630946X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1630947X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1630948X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1630949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1630950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630951X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630952X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630953X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1630954X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630955X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630956X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1630957X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1630958X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1630959X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1630960X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1630961X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1630962X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1630963X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1630964X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1630965X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630966X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630967X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1630968X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630969X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630970X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630971X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630972X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1630973X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630974X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630975X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630976X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630977X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1630978X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1630979X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1630980X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1630981X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630982X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1630983X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630984X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630985X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630986X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630987X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1630988X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1630989X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1630990X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1630991X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1630992X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1630993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1630994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1630995X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1630996X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1630997X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630998X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1630999X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1631000X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1631001X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1631002X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631003X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631004X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631005X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631006X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631007X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631008X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631009X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631010X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631011X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631012X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631013X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631014X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631015X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631016X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631017X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1631019X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1631020X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1631021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1631022X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1631023X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1631024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1631025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1631026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1631028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1631029X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631030X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631031X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631032X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1631034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1631036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1631037X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1631038X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1631039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1631041X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1631043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631044X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631045X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631046X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631050X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631051X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631052X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631058X
         1 "1 YES"
         2 "2 NO" ;

label define H1631059X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631060X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631061X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631066X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631067X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631068X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631073X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631074X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631075X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1631077X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631078X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631079X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1631080X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1631081X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1631082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631084X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1631085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1631086X
         1 "1 YES"
         2 "2 NO" ;

label define H1631087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631088X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631089X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631091X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631092X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1631093X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1631094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631108X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1631109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1631121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1631124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1631125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1631129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1631131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1631132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1631133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1631134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

label define H1631135X
         0 "0.00"
         2138 "$1 - $2,138" ;

label define H1631136X
         0 "0.00"
         511 "$1 - $511" ;

label define H1631137X
         0 "0.00"
         199 "$1 - $199" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1630001X;
label value ACTDTY31 H1630002X;
label value ACTDTY42 H1630003X;
label value ACTDTY53 H1630004X;
label value ACTLIM31 H1630005X;
label value ACTLIM53 H1630006X;
label value ADAPPT42 H1630007X;
label value ADCAPE42 H1630008X;
label value ADCLIM42 H1630009X;
label value ADCMPM42 H1630010X;
label value ADCMPY42 H1630011X;
label value ADDAYA42 H1630012X;
label value ADDOWN42 H1630013X;
label value ADDPRS42 H1630014X;
label value ADDRBP42 H1630015X;
label value ADEFRT42 H1630016X;
label value ADEGMC42 H1630017X;
label value ADESSP42 H1630018X;
label value ADEXPL42 H1630019X;
label value ADEZUN42 H1630020X;
label value ADFFRM42 H1630021X;
label value ADFHLP42 H1630022X;
label value ADGENH42 H1630023X;
label value ADHDADDX H1630024X;
label value ADHDAGED H1630025X;
label value ADHECR42 H1630026X;
label value ADHOPE42 H1630027X;
label value ADILCR42 H1630028X;
label value ADILWW42 H1630029X;
label value ADINSA42 H1630030X;
label value ADINSB42 H1630031X;
label value ADINST42 H1630032X;
label value ADINTR42 H1630033X;
label value ADL3MO31 H1630034X;
label value ADLANG42 H1630035X;
label value ADLHLP31 H1630036X;
label value ADLHLP53 H1630037X;
label value ADLIST42 H1630038X;
label value ADMALS42 H1630039X;
label value ADMWLM42 H1630040X;
label value ADNDCR42 H1630041X;
label value ADNERV42 H1630042X;
label value ADNRGY42 H1630043X;
label value ADNSMK42 H1630044X;
label value ADOVER42 H1630045X;
label value ADPAIN42 H1630046X;
label value ADPALS42 H1630047X;
label value ADPRTM42 H1630048X;
label value ADPRX42 H1630049X;
label value ADPWLM42 H1630050X;
label value ADRESP42 H1630051X;
label value ADREST42 H1630052X;
label value ADRISK42 H1630053X;
label value ADRTCR42 H1630054X;
label value ADRTWW42 H1630055X;
label value ADSAD42 H1630056X;
label value ADSMOK42 H1630057X;
label value ADSOCA42 H1630058X;
label value ADSPEC42 H1630059X;
label value ADTLHW42 H1630060X;
label value ADUPRO42 H1630061X;
label value ADWRTH42 H1630062X;
label value AFDC13 H1630063X;
label value AFTHOU42 H1630064X;
label value AIDHLP31 H1630065X;
label value AIDHLP53 H1630066X;
label value ALIIMP13 H1630067X;
label value AMCOPU13 H1630068X;
label value AMEOFD13 H1630069X;
label value ANGIAGED H1630070X;
label value ANGIDX H1630071X;
label value ANYLMT13 H1630072X;
label value ARTHAGED H1630073X;
label value ARTHDX H1630074X;
label value ARTHTYPE H1630075X;
label value ASACUT53 H1630076X;
label value ASATAK31 H1630077X;
label value ASATAK53 H1630078X;
label value ASDALY53 H1630079X;
label value ASEVFL53 H1630080X;
label value ASIANP42 H1630081X;
label value ASMRCN53 H1630082X;
label value ASPKFL53 H1630083X;
label value ASPREV53 H1630084X;
label value ASPRIN53 H1630085X;
label value ASSTIL31 H1630086X;
label value ASSTIL53 H1630087X;
label value ASTHAGED H1630088X;
label value ASTHDX H1630089X;
label value ASTHEP31 H1630090X;
label value ASTHEP53 H1630091X;
label value ASWNFL53 H1630092X;
label value BEGRFM31 H1630093X;
label value BEGRFM42 H1630094X;
label value BEGRFM53 H1630095X;
label value BEGRFY31 H1630096X;
label value BEGRFY42 H1630097X;
label value BEGRFY53 H1630098X;
label value BENDIF31 H1630099X;
label value BENDIF53 H1630100X;
label value BLCKPR42 H1630101X;
label value BLIND42 H1630102X;
label value BMINDX53 H1630103X;
label value BOOST42 H1630104X;
label value BORNUSA H1630105X;
label value BPCHEK53 H1630106X;
label value BPMLDX H1630107X;
label value BRSTEX53 H1630108X;
label value BSNTY31 H1630109X;
label value BSNTY42 H1630110X;
label value BSNTY53 H1630111X;
label value BSTSRE53 H1630112X;
label value BSTST53 H1630113X;
label value BUSIMP13 H1630114X;
label value CABLADDR H1630115X;
label value CABREAST H1630116X;
label value CACERVIX H1630117X;
label value CACOLON H1630118X;
label value CALUNG H1630119X;
label value CALYMPH H1630120X;
label value CAMELANO H1630121X;
label value CANCERDX H1630122X;
label value CAOTHER H1630123X;
label value CAPROSTA H1630124X;
label value CARECO42 H1630125X;
label value CASKINDK H1630126X;
label value CASKINNM H1630127X;
label value CAUTERUS H1630128X;
label value CHAPPT42 H1630129X;
label value CHBMIX42 H1630130X;
label value CHBRON31 H1630131X;
label value CHBRON53 H1630132X;
label value CHCOUN42 H1630133X;
label value CHDAGED H1630134X;
label value CHDDX H1630135X;
label value CHECK53 H1630136X;
label value CHEMPB42 H1630137X;
label value CHENEC42 H1630138X;
label value CHEXPL42 H1630139X;
label value CHEYRE42 H1630140X;
label value CHGJ3142 H1630141X;
label value CHGJ4253 H1630142X;
label value CHHECR42 H1630143X;
label value CHILCR42 H1630144X;
label value CHILWW42 H1630145X;
label value CHLICO42 H1630146X;
label value CHLIHB42 H1630147X;
label value CHLIMI42 H1630148X;
label value CHLIMP13 H1630149X;
label value CHLIST42 H1630150X;
label value CHNDCR42 H1630151X;
label value CHOIC31 H1630152X;
label value CHOIC42 H1630153X;
label value CHOIC53 H1630154X;
label value CHOLAGED H1630155X;
label value CHOLCK53 H1630156X;
label value CHOLDX H1630157X;
label value CHPMCN42 H1630158X;
label value CHPMED42 H1630159X;
label value CHPMHB42 H1630160X;
label value CHPRTM42 H1630161X;
label value CHRESP42 H1630162X;
label value CHRTCR42 H1630163X;
label value CHRTWW42 H1630164X;
label value CHSERV42 H1630165X;
label value CHSPEC42 H1630166X;
label value CHSRCN42 H1630167X;
label value CHSRHB42 H1630168X;
label value CHTHCO42 H1630169X;
label value CHTHER42 H1630170X;
label value CHTHHB42 H1630171X;
label value CLINIC42 H1630172X;
label value CLMDEP13 H1630173X;
label value CLMHIP13 H1630174X;
label value CLNTRE53 H1630175X;
label value CLNTST53 H1630176X;
label value COGLIM31 H1630177X;
label value COGLIM53 H1630178X;
label value COVRMM H1630179X;
label value COVRYY H1630180X;
label value CSHCN42 H1630181X;
label value CSHIMP13 H1630182X;
label value DADPRO42 H1630183X;
label value DDNSCL31 H1630184X;
label value DDNSCL42 H1630185X;
label value DDNSCL53 H1630186X;
label value DDNWRK31 H1630187X;
label value DDNWRK42 H1630188X;
label value DDNWRK53 H1630189X;
label value DEAF42 H1630190X;
label value DECIDE42 H1630191X;
label value DEDUCT13 H1630192X;
label value DENTAL42 H1630193X;
label value DENTCK53 H1630194X;
label value DENTIN31 H1630195X;
label value DENTIN42 H1630196X;
label value DENTIN53 H1630197X;
label value DEPDNT13 H1630198X;
label value DFCOG42 H1630199X;
label value DFDRSB42 H1630200X;
label value DFERND42 H1630201X;
label value DFHEAR42 H1630202X;
label value DFSEE42 H1630203X;
label value DFTOUS42 H1630204X;
label value DFWLKC42 H1630205X;
label value DIABAGED H1630206X;
label value DIABDX H1630207X;
label value DIFFPL42 H1630208X;
label value DIFFWG31 H1630209X;
label value DIFFWG42 H1630210X;
label value DIFFWG53 H1630211X;
label value DISVW31X H1630212X;
label value DISVW42X H1630213X;
label value DISVW53X H1630214X;
label value DIVIMP13 H1630215X;
label value DKWHRU42 H1630216X;
label value DNDLAY42 H1630217X;
label value DNDLPR42 H1630218X;
label value DNDLRS42 H1630219X;
label value DNTINS13 H1630220X;
label value DNTINS31 H1630221X;
label value DNUNAB42 H1630222X;
label value DNUNPR42 H1630223X;
label value DNUNRS42 H1630224X;
label value DOBMM H1630225X;
label value DOBYY H1630226X;
label value DOCELS42 H1630227X;
label value DPINRU13 H1630228X;
label value DPOTSD13 H1630229X;
label value DSA1C53 H1630230X;
label value DSCB1253 H1630231X;
label value DSCGRP53 H1630232X;
label value DSCH1253 H1630233X;
label value DSCH1353 H1630234X;
label value DSCH1453 H1630235X;
label value DSCHNV53 H1630236X;
label value DSCINT53 H1630237X;
label value DSCNPC53 H1630238X;
label value DSCONF53 H1630239X;
label value DSCPCP53 H1630240X;
label value DSCPHN53 H1630241X;
label value DSDIA53 H1630242X;
label value DSDIET53 H1630243X;
label value DSEB1253 H1630244X;
label value DSEY1253 H1630245X;
label value DSEY1353 H1630246X;
label value DSEY1453 H1630247X;
label value DSEYNV53 H1630248X;
label value DSEYPR53 H1630249X;
label value DSFB1253 H1630250X;
label value DSFL1253 H1630251X;
label value DSFL1353 H1630252X;
label value DSFL1453 H1630253X;
label value DSFLNV53 H1630254X;
label value DSFT1253 H1630255X;
label value DSFT1353 H1630256X;
label value DSFT1453 H1630257X;
label value DSFTNV53 H1630258X;
label value DSINSU53 H1630259X;
label value DSKIDN53 H1630260X;
label value DSMED53 H1630261X;
label value DSPRX53 H1630262X;
label value DSVB1253 H1630263X;
label value DVGEN13 H1630264X;
label value DVOOFD13 H1630265X;
label value DVOOPU13 H1630266X;
label value DVOOSR13 H1630267X;
label value DVORTH13 H1630268X;
label value DVTOT13 H1630269X;
label value EATHLT42 H1630270X;
label value EDRECODE H1630271X;
label value EDUYRDG H1630272X;
label value EICRDT13 H1630273X;
label value ELGRND13 H1630274X;
label value ELGRND31 H1630275X;
label value ELGRND42 H1630276X;
label value ELGRND53 H1630277X;
label value EMPHAGED H1630278X;
label value EMPHDX H1630279X;
label value EMPST31 H1630280X;
label value EMPST42 H1630281X;
label value EMPST53 H1630282X;
label value ENDRFM13 H1630283X;
label value ENDRFM31 H1630284X;
label value ENDRFM42 H1630285X;
label value ENDRFM53 H1630286X;
label value ENDRFY13 H1630287X;
label value ENDRFY31 H1630288X;
label value ENDRFY42 H1630289X;
label value ENDRFY53 H1630290X;
label value ENGCMF42 H1630291X;
label value ENGSPK42 H1630292X;
label value ERTOT13 H1630293X;
label value EVRETIRE H1630294X;
label value EVRWRK H1630295X;
label value EXPLOP42 H1630296X;
label value EXRCIS53 H1630297X;
label value FAMRFPYR H1630298X;
label value FAMSZE31 H1630299X;
label value FAMSZE42 H1630300X;
label value FAMSZE53 H1630301X;
label value FCRP1231 H1630302X;
label value FILEDR13 H1630303X;
label value FILER13 H1630304X;
label value FLSTAT13 H1630305X;
label value FLUSHT53 H1630306X;
label value FMRS1231 H1630307X;
label value FNGRDF31 H1630308X;
label value FNGRDF53 H1630309X;
label value FOODMN13 H1630310X;
label value FOODST13 H1630311X;
label value FOODVL13 H1630312X;
label value FSAAMT31 H1630313X;
label value FSAGT31 H1630314X;
label value FTSTU13X H1630315X;
label value FTSTU31X H1630316X;
label value FTSTU42X H1630317X;
label value FTSTU53X H1630318X;
label value GENDRP42 H1630319X;
label value GOTOUS42 H1630320X;
label value HASFSA31 H1630321X;
label value HAVEUS42 H1630322X;
label value HAVFUN42 H1630323X;
label value HEALTH42 H1630324X;
label value HEARAD42 H1630325X;
label value HELD31X H1630326X;
label value HELD42X H1630327X;
label value HELD53X H1630328X;
label value HELMET42 H1630329X;
label value HHAGD13 H1630330X;
label value HHINDD13 H1630331X;
label value HHINFD13 H1630332X;
label value HHNOPU13 H1630333X;
label value HHNOSR13 H1630334X;
label value HHNVA13 H1630335X;
label value HHTOTD13 H1630336X;
label value HIBPAGED H1630337X;
label value HIBPDX H1630338X;
label value HISPANX H1630339X;
label value HISPCAT H1630340X;
label value HISPNCAT H1630341X;
label value HLTHLF42 H1630342X;
label value HOMEBH42 H1630343X;
label value HONRDC31 H1630344X;
label value HONRDC42 H1630345X;
label value HONRDC53 H1630346X;
label value HOUR31 H1630347X;
label value HOUR42 H1630348X;
label value HOUR53 H1630349X;
label value HPDAP13 H1630350X;
label value HPDAU13 H1630351X;
label value HPDDE13 H1630352X;
label value HPDFE13 H1630353X;
label value HPDJA13 H1630354X;
label value HPDJL13 H1630355X;
label value HPDJU13 H1630356X;
label value HPDMA13 H1630357X;
label value HPDMY13 H1630358X;
label value HPDNO13 H1630359X;
label value HPDOC13 H1630360X;
label value HPDSE13 H1630361X;
label value HPEAP13 H1630362X;
label value HPEAU13 H1630363X;
label value HPEDE13 H1630364X;
label value HPEFE13 H1630365X;
label value HPEJA13 H1630366X;
label value HPEJL13 H1630367X;
label value HPEJU13 H1630368X;
label value HPEMA13 H1630369X;
label value HPEMY13 H1630370X;
label value HPENO13 H1630371X;
label value HPEOC13 H1630372X;
label value HPESE13 H1630373X;
label value HPNAP13 H1630374X;
label value HPNAU13 H1630375X;
label value HPNDE13 H1630376X;
label value HPNFE13 H1630377X;
label value HPNJA13 H1630378X;
label value HPNJL13 H1630379X;
label value HPNJU13 H1630380X;
label value HPNMA13 H1630381X;
label value HPNMY13 H1630382X;
label value HPNNO13 H1630383X;
label value HPNOC13 H1630384X;
label value HPNSE13 H1630385X;
label value HPOAP13 H1630386X;
label value HPOAU13 H1630387X;
label value HPODE13 H1630388X;
label value HPOFE13 H1630389X;
label value HPOJA13 H1630390X;
label value HPOJL13 H1630391X;
label value HPOJU13 H1630392X;
label value HPOMA13 H1630393X;
label value HPOMY13 H1630394X;
label value HPONO13 H1630395X;
label value HPOOC13 H1630396X;
label value HPOSE13 H1630397X;
label value HPRAP13 H1630398X;
label value HPRAU13 H1630399X;
label value HPRDE13 H1630400X;
label value HPRFE13 H1630401X;
label value HPRJA13 H1630402X;
label value HPRJL13 H1630403X;
label value HPRJU13 H1630404X;
label value HPRMA13 H1630405X;
label value HPRMY13 H1630406X;
label value HPRNO13 H1630407X;
label value HPROC13 H1630408X;
label value HPRSE13 H1630409X;
label value HPSAP13 H1630410X;
label value HPSAU13 H1630411X;
label value HPSDE13 H1630412X;
label value HPSFE13 H1630413X;
label value HPSJA13 H1630414X;
label value HPSJL13 H1630415X;
label value HPSJU13 H1630416X;
label value HPSMA13 H1630417X;
label value HPSMY13 H1630418X;
label value HPSNO13 H1630419X;
label value HPSOC13 H1630420X;
label value HPSSE13 H1630421X;
label value HRHOW31 H1630422X;
label value HRHOW42 H1630423X;
label value HRHOW53 H1630424X;
label value HRWG31X H1630425X;
label value HRWG42X H1630426X;
label value HRWG53X H1630427X;
label value HRWGIM31 H1630428X;
label value HRWGIM42 H1630429X;
label value HRWGIM53 H1630430X;
label value HSELIM31 H1630431X;
label value HSELIM53 H1630432X;
label value HSPLAP42 H1630433X;
label value HWELLSPE H1630434X;
label value HYSTER53 H1630435X;
label value IADL3M31 H1630436X;
label value IADLHP31 H1630437X;
label value IADLHP53 H1630438X;
label value INDCAT31 H1630439X;
label value INDCAT42 H1630440X;
label value INDCAT53 H1630441X;
label value INS13X H1630442X;
label value INS31X H1630443X;
label value INS42X H1630444X;
label value INS53X H1630445X;
label value INSAP13X H1630446X;
label value INSAT13X H1630447X;
label value INSAT31X H1630448X;
label value INSAT42X H1630449X;
label value INSAT53X H1630450X;
label value INSAU13X H1630451X;
label value INSC1231 H1630452X;
label value INSCOP13 H1630453X;
label value INSCOP31 H1630454X;
label value INSCOP42 H1630455X;
label value INSCOP53 H1630456X;
label value INSCOPE H1630457X;
label value INSCOV13 H1630458X;
label value INSDE13X H1630459X;
label value INSENDMM H1630460X;
label value INSENDYY H1630461X;
label value INSFE13X H1630462X;
label value INSJA13X H1630463X;
label value INSJL13X H1630464X;
label value INSJU13X H1630465X;
label value INSMA13X H1630466X;
label value INSMY13X H1630467X;
label value INSNO13X H1630468X;
label value INSOC13X H1630469X;
label value INSRPL42 H1630470X;
label value INSSE13X H1630471X;
label value INSURC13 H1630472X;
label value INTIMP13 H1630473X;
label value INTVLANG H1630474X;
label value IPDIS13 H1630475X;
label value IPDOFD13 H1630476X;
label value IPZERO13 H1630477X;
label value IRAIMP13 H1630478X;
label value JNTPID13 H1630479X;
label value JOBORG31 H1630480X;
label value JOBORG42 H1630481X;
label value JOBORG53 H1630482X;
label value JOBRSN42 H1630483X;
label value JTINRU13 H1630484X;
label value JTPAIN31 H1630485X;
label value JTPAIN53 H1630486X;
label value K6SUM42 H1630487X;
label value KEYNESS H1630488X;
label value KIDPRO42 H1630489X;
label value KNOWDR42 H1630490X;
label value LANGHM42 H1630491X;
label value LANGPR42 H1630492X;
label value LANGSPK H1630493X;
label value LAPBLT42 H1630494X;
label value LFTDIF31 H1630495X;
label value LFTDIF53 H1630496X;
label value LIVEUS42 H1630497X;
label value LOCATN42 H1630498X;
label value LSHLTH42 H1630499X;
label value LSTETH53 H1630500X;
label value MAMOGR53 H1630501X;
label value MARRY13X H1630502X;
label value MARRY31X H1630503X;
label value MARRY42X H1630504X;
label value MARRY53X H1630505X;
label value MCAID13 H1630506X;
label value MCAID13X H1630507X;
label value MCAID31 H1630508X;
label value MCAID31X H1630509X;
label value MCAID42 H1630510X;
label value MCAID42X H1630511X;
label value MCAID53 H1630512X;
label value MCAID53X H1630513X;
label value MCARE13 H1630514X;
label value MCARE13X H1630515X;
label value MCARE31 H1630516X;
label value MCARE31X H1630517X;
label value MCARE42 H1630518X;
label value MCARE42X H1630519X;
label value MCARE53 H1630520X;
label value MCARE53X H1630521X;
label value MCDAP13 H1630522X;
label value MCDAP13X H1630523X;
label value MCDAT13X H1630524X;
label value MCDAT31X H1630525X;
label value MCDAT42X H1630526X;
label value MCDAT53X H1630527X;
label value MCDAU13 H1630528X;
label value MCDAU13X H1630529X;
label value MCDDE13 H1630530X;
label value MCDDE13X H1630531X;
label value MCDEV13 H1630532X;
label value MCDFE13 H1630533X;
label value MCDFE13X H1630534X;
label value MCDHMO13 H1630535X;
label value MCDHMO31 H1630536X;
label value MCDHMO42 H1630537X;
label value MCDJA13 H1630538X;
label value MCDJA13X H1630539X;
label value MCDJL13 H1630540X;
label value MCDJL13X H1630541X;
label value MCDJU13 H1630542X;
label value MCDJU13X H1630543X;
label value MCDMA13 H1630544X;
label value MCDMA13X H1630545X;
label value MCDMC13 H1630546X;
label value MCDMC31 H1630547X;
label value MCDMC42 H1630548X;
label value MCDMY13 H1630549X;
label value MCDMY13X H1630550X;
label value MCDNO13 H1630551X;
label value MCDNO13X H1630552X;
label value MCDOC13 H1630553X;
label value MCDOC13X H1630554X;
label value MCDSE13 H1630555X;
label value MCDSE13X H1630556X;
label value MCRAP13 H1630557X;
label value MCRAP13X H1630558X;
label value MCRAU13 H1630559X;
label value MCRAU13X H1630560X;
label value MCRDE13 H1630561X;
label value MCRDE13X H1630562X;
label value MCREV13 H1630563X;
label value MCRFE13 H1630564X;
label value MCRFE13X H1630565X;
label value MCRJA13 H1630566X;
label value MCRJA13X H1630567X;
label value MCRJL13 H1630568X;
label value MCRJL13X H1630569X;
label value MCRJU13 H1630570X;
label value MCRJU13X H1630571X;
label value MCRMA13 H1630572X;
label value MCRMA13X H1630573X;
label value MCRMY13 H1630574X;
label value MCRMY13X H1630575X;
label value MCRNO13 H1630576X;
label value MCRNO13X H1630577X;
label value MCROC13 H1630578X;
label value MCROC13X H1630579X;
label value MCRPB13 H1630580X;
label value MCRPB31 H1630581X;
label value MCRPB42 H1630582X;
label value MCRPD13 H1630583X;
label value MCRPD13X H1630584X;
label value MCRPD31 H1630585X;
label value MCRPD31X H1630586X;
label value MCRPD42 H1630587X;
label value MCRPD42X H1630588X;
label value MCRPHO13 H1630589X;
label value MCRPHO31 H1630590X;
label value MCRPHO42 H1630591X;
label value MCRSE13 H1630592X;
label value MCRSE13X H1630593X;
label value MDDLAY42 H1630594X;
label value MDDLPR42 H1630595X;
label value MDDLRS42 H1630596X;
label value MDUNAB42 H1630597X;
label value MDUNPR42 H1630598X;
label value MDUNRS42 H1630599X;
label value MESBPR42 H1630600X;
label value MESHGT42 H1630601X;
label value MESVIS42 H1630602X;
label value MESWGT42 H1630603X;
label value MIAGED H1630604X;
label value MIDX H1630605X;
label value MILDIF31 H1630606X;
label value MILDIF53 H1630607X;
label value MINORP42 H1630608X;
label value MNHLTH31 H1630609X;
label value MNHLTH42 H1630610X;
label value MNHLTH53 H1630611X;
label value MOMPRO42 H1630612X;
label value MORE31 H1630613X;
label value MORE42 H1630614X;
label value MORE53 H1630615X;
label value MORECOVR H1630616X;
label value MORJOB31 H1630617X;
label value MORJOB42 H1630618X;
label value MORJOB53 H1630619X;
label value MYSELF42 H1630620X;
label value NATAMP42 H1630621X;
label value NERVAF42 H1630622X;
label value NEVILL42 H1630623X;
label value NEWARE42 H1630624X;
label value NEWDOC42 H1630625X;
label value NHRWG31 H1630626X;
label value NHRWG42 H1630627X;
label value NHRWG53 H1630628X;
label value NOASPR53 H1630629X;
label value NOFAT53 H1630630X;
label value NOGODR42 H1630631X;
label value NOHINS42 H1630632X;
label value NOINSBEF H1630633X;
label value NOINSTM H1630634X;
label value NOINUNIT H1630635X;
label value NOLIKE42 H1630636X;
label value NOREAS42 H1630637X;
label value NOSMOK42 H1630638X;
label value NUMEMP31 H1630639X;
label value NUMEMP42 H1630640X;
label value NUMEMP53 H1630641X;
label value NWK31 H1630642X;
label value NWK42 H1630643X;
label value NWK53 H1630644X;
label value OBASST13 H1630645X;
label value OBCHIR13 H1630646X;
label value OBCOPU13 H1630647X;
label value OBDRV13 H1630648X;
label value OBNURS13 H1630649X;
label value OBOPTO13 H1630650X;
label value OBOTHV13 H1630651X;
label value OBTHER13 H1630652X;
label value OBTOTV13 H1630653X;
label value OCCCAT31 H1630654X;
label value OCCCAT42 H1630655X;
label value OCCCAT53 H1630656X;
label value OFFER31X H1630657X;
label value OFFER42X H1630658X;
label value OFFER53X H1630659X;
label value OFFHOU42 H1630660X;
label value OFREMP31 H1630661X;
label value OFREMP42 H1630662X;
label value OFREMP53 H1630663X;
label value OHRTAGED H1630664X;
label value OHRTDX H1630665X;
label value ONGONG42 H1630666X;
label value ONJOB42 H1630667X;
label value OPAAP13 H1630668X;
label value OPAAU13 H1630669X;
label value OPADE13 H1630670X;
label value OPAEV13 H1630671X;
label value OPAFE13 H1630672X;
label value OPAJA13 H1630673X;
label value OPAJL13 H1630674X;
label value OPAJU13 H1630675X;
label value OPAMA13 H1630676X;
label value OPAMY13 H1630677X;
label value OPANO13 H1630678X;
label value OPAOC13 H1630679X;
label value OPASE13 H1630680X;
label value OPBAP13 H1630681X;
label value OPBAU13 H1630682X;
label value OPBDE13 H1630683X;
label value OPBEV13 H1630684X;
label value OPBFE13 H1630685X;
label value OPBJA13 H1630686X;
label value OPBJL13 H1630687X;
label value OPBJU13 H1630688X;
label value OPBMA13 H1630689X;
label value OPBMY13 H1630690X;
label value OPBNO13 H1630691X;
label value OPBOC13 H1630692X;
label value OPBSE13 H1630693X;
label value OPDRV13 H1630694X;
label value OPOTHV13 H1630695X;
label value OPTOTV13 H1630696X;
label value OTHDYS31 H1630697X;
label value OTHDYS42 H1630698X;
label value OTHDYS53 H1630699X;
label value OTHIMP13 H1630700X;
label value OTHINS42 H1630701X;
label value OTHLANG H1630702X;
label value OTHNDD31 H1630703X;
label value OTHNDD42 H1630704X;
label value OTHNDD53 H1630705X;
label value OTHOFD13 H1630706X;
label value OTHRCP42 H1630707X;
label value OTHREA42 H1630708X;
label value OTPAAT13 H1630709X;
label value OTPAAT31 H1630710X;
label value OTPAAT42 H1630711X;
label value OTPAAT53 H1630712X;
label value OTPBAT13 H1630713X;
label value OTPBAT31 H1630714X;
label value OTPBAT42 H1630715X;
label value OTPBAT53 H1630716X;
label value OTPUBA13 H1630717X;
label value OTPUBA31 H1630718X;
label value OTPUBA42 H1630719X;
label value OTPUBA53 H1630720X;
label value OTPUBB13 H1630721X;
label value OTPUBB31 H1630722X;
label value OTPUBB42 H1630723X;
label value OTPUBB53 H1630724X;
label value PACISP42 H1630725X;
label value PANEL H1630726X;
label value PAPSMR53 H1630727X;
label value PAYDR31 H1630728X;
label value PAYDR42 H1630729X;
label value PAYDR53 H1630730X;
label value PAYVAC31 H1630731X;
label value PAYVAC42 H1630732X;
label value PAYVAC53 H1630733X;
label value PDKAP13 H1630734X;
label value PDKAU13 H1630735X;
label value PDKDE13 H1630736X;
label value PDKFE13 H1630737X;
label value PDKJA13 H1630738X;
label value PDKJL13 H1630739X;
label value PDKJU13 H1630740X;
label value PDKMA13 H1630741X;
label value PDKMY13 H1630742X;
label value PDKNO13 H1630743X;
label value PDKOC13 H1630744X;
label value PDKSE13 H1630745X;
label value PEGAP13 H1630746X;
label value PEGAU13 H1630747X;
label value PEGDE13 H1630748X;
label value PEGFE13 H1630749X;
label value PEGJA13 H1630750X;
label value PEGJL13 H1630751X;
label value PEGJU13 H1630752X;
label value PEGMA13 H1630753X;
label value PEGMY13 H1630754X;
label value PEGNO13 H1630755X;
label value PEGOC13 H1630756X;
label value PEGSE13 H1630757X;
label value PENIMP13 H1630758X;
label value PERSLA42 H1630759X;
label value PHMONP31 H1630760X;
label value PHMONP42 H1630761X;
label value PHNREG42 H1630762X;
label value PHQ242 H1630763X;
label value PHYEXE53 H1630764X;
label value PHYSCL42 H1630765X;
label value PLCTYP42 H1630766X;
label value PMDINS13 H1630767X;
label value PMDINS31 H1630768X;
label value PMDLAY42 H1630769X;
label value PMDLPR42 H1630770X;
label value PMDLRS42 H1630771X;
label value PMEDIN31 H1630772X;
label value PMEDIN42 H1630773X;
label value PMEDIN53 H1630774X;
label value PMEDPP31 H1630775X;
label value PMEDPP42 H1630776X;
label value PMEDPY31 H1630777X;
label value PMEDPY42 H1630778X;
label value PMEDPY53 H1630779X;
label value PMEDUP31 H1630780X;
label value PMEDUP42 H1630781X;
label value PMEDUP53 H1630782X;
label value PMNCNP31 H1630783X;
label value PMNCNP42 H1630784X;
label value PMUNAB42 H1630785X;
label value PMUNPR42 H1630786X;
label value PMUNRS42 H1630787X;
label value PNGAP13 H1630788X;
label value PNGAU13 H1630789X;
label value PNGDE13 H1630790X;
label value PNGFE13 H1630791X;
label value PNGJA13 H1630792X;
label value PNGJL13 H1630793X;
label value PNGJU13 H1630794X;
label value PNGMA13 H1630795X;
label value PNGMY13 H1630796X;
label value PNGNO13 H1630797X;
label value PNGOC13 H1630798X;
label value PNGSE13 H1630799X;
label value POGAP13 H1630800X;
label value POGAU13 H1630801X;
label value POGDE13 H1630802X;
label value POGFE13 H1630803X;
label value POGJA13 H1630804X;
label value POGJL13 H1630805X;
label value POGJU13 H1630806X;
label value POGMA13 H1630807X;
label value POGMY13 H1630808X;
label value POGNO13 H1630809X;
label value POGOC13 H1630810X;
label value POGSE13 H1630811X;
label value POUAP13 H1630812X;
label value POUAU13 H1630813X;
label value POUDE13 H1630814X;
label value POUFE13 H1630815X;
label value POUJA13 H1630816X;
label value POUJL13 H1630817X;
label value POUJU13 H1630818X;
label value POUMA13 H1630819X;
label value POUMY13 H1630820X;
label value POUNO13 H1630821X;
label value POUOC13 H1630822X;
label value POUSE13 H1630823X;
label value POVCAT13 H1630824X;
label value PRDRNP31 H1630825X;
label value PRDRNP42 H1630826X;
label value PREGNT31 H1630827X;
label value PREGNT42 H1630828X;
label value PREGNT53 H1630829X;
label value PREVCOVR H1630830X;
label value PREVEN42 H1630831X;
label value PRIAP13 H1630832X;
label value PRIAU13 H1630833X;
label value PRIDE13 H1630834X;
label value PRIDK13 H1630835X;
label value PRIDK31 H1630836X;
label value PRIDK42 H1630837X;
label value PRIDK53 H1630838X;
label value PRIEU13 H1630839X;
label value PRIEU31 H1630840X;
label value PRIEU42 H1630841X;
label value PRIEU53 H1630842X;
label value PRIFE13 H1630843X;
label value PRIJA13 H1630844X;
label value PRIJL13 H1630845X;
label value PRIJU13 H1630846X;
label value PRIMA13 H1630847X;
label value PRIMY13 H1630848X;
label value PRING13 H1630849X;
label value PRING31 H1630850X;
label value PRING42 H1630851X;
label value PRING53 H1630852X;
label value PRINO13 H1630853X;
label value PRIOC13 H1630854X;
label value PRIOG13 H1630855X;
label value PRIOG31 H1630856X;
label value PRIOG42 H1630857X;
label value PRIOG53 H1630858X;
label value PRIS13 H1630859X;
label value PRIS31 H1630860X;
label value PRIS42 H1630861X;
label value PRIS53 H1630862X;
label value PRISE13 H1630863X;
label value PRIV13 H1630864X;
label value PRIV31 H1630865X;
label value PRIV42 H1630866X;
label value PRIV53 H1630867X;
label value PRIVAT13 H1630868X;
label value PRIVAT31 H1630869X;
label value PRIVAT42 H1630870X;
label value PRIVAT53 H1630871X;
label value PROUT13 H1630872X;
label value PROUT31 H1630873X;
label value PROUT42 H1630874X;
label value PROUT53 H1630875X;
label value PROVTY42 H1630876X;
label value PROXY13 H1630877X;
label value PROXY31 H1630878X;
label value PROXY42 H1630879X;
label value PROXY53 H1630880X;
label value PRSAP13 H1630881X;
label value PRSAU13 H1630882X;
label value PRSDE13 H1630883X;
label value PRSFE13 H1630884X;
label value PRSJA13 H1630885X;
label value PRSJL13 H1630886X;
label value PRSJU13 H1630887X;
label value PRSMA13 H1630888X;
label value PRSMY13 H1630889X;
label value PRSNO13 H1630890X;
label value PRSOC13 H1630891X;
label value PRSSE13 H1630892X;
label value PRVDRL31 H1630893X;
label value PRVDRL42 H1630894X;
label value PRVEV13 H1630895X;
label value PRVHMO13 H1630896X;
label value PRVHMO31 H1630897X;
label value PRVHMO42 H1630898X;
label value PRVMNC31 H1630899X;
label value PRVMNC42 H1630900X;
label value PRVSPK42 H1630901X;
label value PSA53 H1630902X;
label value PSTATS31 H1630903X;
label value PSTATS42 H1630904X;
label value PSTATS53 H1630905X;
label value PUB13X H1630906X;
label value PUB31X H1630907X;
label value PUB42X H1630908X;
label value PUB53X H1630909X;
label value PUBAP13X H1630910X;
label value PUBAT13X H1630911X;
label value PUBAT31X H1630912X;
label value PUBAT42X H1630913X;
label value PUBAT53X H1630914X;
label value PUBAU13X H1630915X;
label value PUBDE13X H1630916X;
label value PUBFE13X H1630917X;
label value PUBIMP13 H1630918X;
label value PUBJA13X H1630919X;
label value PUBJL13X H1630920X;
label value PUBJU13X H1630921X;
label value PUBMA13X H1630922X;
label value PUBMY13X H1630923X;
label value PUBNO13X H1630924X;
label value PUBOC13X H1630925X;
label value PUBSE13X H1630926X;
label value RACEAX H1630927X;
label value RACEBX H1630928X;
label value RACETHX H1630929X;
label value RACEV1X H1630930X;
label value RACEV2X H1630931X;
label value RACEVER H1630932X;
label value RACEWX H1630933X;
label value RCHDIF31 H1630934X;
label value RCHDIF53 H1630935X;
label value REFFRL42 H1630936X;
label value REFRL13X H1630937X;
label value REFRL31X H1630938X;
label value REFRL42X H1630939X;
label value REFRL53X H1630940X;
label value REGION13 H1630941X;
label value REGION31 H1630942X;
label value REGION42 H1630943X;
label value REGION53 H1630944X;
label value RESP13 H1630945X;
label value RESP31 H1630946X;
label value RESP42 H1630947X;
label value RESP53 H1630948X;
label value RESPCT42 H1630949X;
label value RETPLN31 H1630950X;
label value RETPLN42 H1630951X;
label value RETPLN53 H1630952X;
label value RNDFLG31 H1630953X;
label value RTHLTH31 H1630954X;
label value RTHLTH42 H1630955X;
label value RTHLTH53 H1630956X;
label value RUCLAS13 H1630957X;
label value RUCLAS31 H1630958X;
label value RUCLAS42 H1630959X;
label value RUCLAS53 H1630960X;
label value RUSIZE13 H1630961X;
label value RUSIZE31 H1630962X;
label value RUSIZE42 H1630963X;
label value RUSIZE53 H1630964X;
label value SAFEST42 H1630965X;
label value SALIMP13 H1630966X;
label value SAQELIG H1630967X;
label value SCHLBH42 H1630968X;
label value SCHLIM31 H1630969X;
label value SCHLIM53 H1630970X;
label value SCHPRO42 H1630971X;
label value SEATBE53 H1630972X;
label value SELDSI42 H1630973X;
label value SELFCM31 H1630974X;
label value SELFCM42 H1630975X;
label value SELFCM53 H1630976X;
label value SEX H1630977X;
label value SFFLAG42 H1630978X;
label value SGMTRE53 H1630979X;
label value SGMTST53 H1630980X;
label value SIBPRO42 H1630981X;
label value SICEAS42 H1630982X;
label value SICPAY31 H1630983X;
label value SICPAY42 H1630984X;
label value SICPAY53 H1630985X;
label value SOCLIM31 H1630986X;
label value SOCLIM53 H1630987X;
label value SPOUID13 H1630988X;
label value SPOUID31 H1630989X;
label value SPOUID42 H1630990X;
label value SPOUID53 H1630991X;
label value SPOUIN13 H1630992X;
label value SPOUIN31 H1630993X;
label value SPOUIN42 H1630994X;
label value SPOUIN53 H1630995X;
label value SPRPRO42 H1630996X;
label value SSCIMP13 H1630997X;
label value SSIIMP13 H1630998X;
label value SSNLJB31 H1630999X;
label value SSNLJB42 H1631000X;
label value SSNLJB53 H1631001X;
label value STAAP13 H1631002X;
label value STAAU13 H1631003X;
label value STADE13 H1631004X;
label value STAFE13 H1631005X;
label value STAJA13 H1631006X;
label value STAJL13 H1631007X;
label value STAJU13 H1631008X;
label value STAMA13 H1631009X;
label value STAMY13 H1631010X;
label value STANO13 H1631011X;
label value STAOC13 H1631012X;
label value STAPR13 H1631013X;
label value STAPR31 H1631014X;
label value STAPR42 H1631015X;
label value STAPR53 H1631016X;
label value STASE13 H1631017X;
label value STJBMM31 H1631018X;
label value STJBMM42 H1631019X;
label value STJBMM53 H1631020X;
label value STJBYY31 H1631021X;
label value STJBYY42 H1631022X;
label value STJBYY53 H1631023X;
label value STNDIF31 H1631024X;
label value STNDIF53 H1631025X;
label value STOMCH53 H1631026X;
label value STPDIF31 H1631027X;
label value STPDIF53 H1631028X;
label value STPRAT13 H1631029X;
label value STPRAT31 H1631030X;
label value STPRAT42 H1631031X;
label value STPRAT53 H1631032X;
label value STRKAGED H1631033X;
label value STRKDX H1631034X;
label value TAXFRM13 H1631035X;
label value TEMPJB31 H1631036X;
label value TEMPJB42 H1631037X;
label value TEMPJB53 H1631038X;
label value TIMALN42 H1631039X;
label value TMTKUS42 H1631040X;
label value TRANS42 H1631041X;
label value TRBLE42 H1631042X;
label value TREATM42 H1631043X;
label value TRIAP13X H1631044X;
label value TRIAT13X H1631045X;
label value TRIAT31X H1631046X;
label value TRIAT42X H1631047X;
label value TRIAT53X H1631048X;
label value TRIAU13X H1631049X;
label value TRICH13X H1631050X;
label value TRICH31X H1631051X;
label value TRICH42X H1631052X;
label value TRICR13X H1631053X;
label value TRICR31X H1631054X;
label value TRICR42X H1631055X;
label value TRICR53X H1631056X;
label value TRIDE13X H1631057X;
label value TRIEV13 H1631058X;
label value TRIEX13X H1631059X;
label value TRIEX31X H1631060X;
label value TRIEX42X H1631061X;
label value TRIFE13X H1631062X;
label value TRIJA13X H1631063X;
label value TRIJL13X H1631064X;
label value TRIJU13X H1631065X;
label value TRILI13X H1631066X;
label value TRILI31X H1631067X;
label value TRILI42X H1631068X;
label value TRIMA13X H1631069X;
label value TRIMY13X H1631070X;
label value TRINO13X H1631071X;
label value TRIOC13X H1631072X;
label value TRIPR13X H1631073X;
label value TRIPR31X H1631074X;
label value TRIPR42X H1631075X;
label value TRISE13X H1631076X;
label value TRIST13X H1631077X;
label value TRIST31X H1631078X;
label value TRIST42X H1631079X;
label value TRTIMP13 H1631080X;
label value TYPEPE42 H1631081X;
label value UNABLE31 H1631082X;
label value UNABLE53 H1631083X;
label value UNEIMP13 H1631084X;
label value UNHAP42 H1631085X;
label value UNINS13 H1631086X;
label value UNION31 H1631087X;
label value UNION42 H1631088X;
label value UNION53 H1631089X;
label value USBORN42 H1631090X;
label value USCNOT42 H1631091X;
label value VETIMP13 H1631092X;
label value WAGIMP13 H1631093X;
label value WASAFDC H1631094X;
label value WASCHAMP H1631095X;
label value WASESTB H1631096X;
label value WASMCAID H1631097X;
label value WASMCARE H1631098X;
label value WASOTGOV H1631099X;
label value WASOTHER H1631100X;
label value WASPRIV H1631101X;
label value WASSSI H1631102X;
label value WASSTAT1 H1631103X;
label value WASSTAT2 H1631104X;
label value WASSTAT3 H1631105X;
label value WASSTAT4 H1631106X;
label value WASVA H1631107X;
label value WCPIMP13 H1631108X;
label value WHITPR42 H1631109X;
label value WHNBPR42 H1631110X;
label value WHNBST42 H1631111X;
label value WHNDEN42 H1631112X;
label value WHNEAT42 H1631113X;
label value WHNHEL42 H1631114X;
label value WHNHGT42 H1631115X;
label value WHNLAP42 H1631116X;
label value WHNPHY42 H1631117X;
label value WHNSAF42 H1631118X;
label value WHNSMK42 H1631119X;
label value WHNWGT42 H1631120X;
label value WILFIL13 H1631121X;
label value WLK3MO31 H1631122X;
label value WLKDIF31 H1631123X;
label value WLKDIF53 H1631124X;
label value WLKLIM31 H1631125X;
label value WLKLIM53 H1631126X;
label value WRGLAS42 H1631127X;
label value WRHLTH42 H1631128X;
label value WRKLIM31 H1631129X;
label value WRKLIM53 H1631130X;
label value YCHJ3142 H1631131X;
label value YCHJ4253 H1631132X;
label value YNOUSC42 H1631133X;
label value YRSINUS H1631134X;
label value ZIDSTL13 H1631135X;
label value ZIDTRI13 H1631136X;
label value ZIFOFD13 H1631137X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H163.LOG and a data file named H163.DTA.  If these files (H163.DTA and H163.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

